/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.world.manager;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.erosion.bukkit.BukkitLecterns;
import org.geysermc.erosion.bukkit.BukkitUtils;
import org.geysermc.erosion.bukkit.SchedulerUtils;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityInfo;

public class GeyserSpigotWorldManager
extends WorldManager {
    private final Plugin plugin;
    private final BukkitLecterns lecterns;

    public GeyserSpigotWorldManager(Plugin plugin) {
        this.plugin = plugin;
        this.lecterns = new BukkitLecterns(plugin);
    }

    @Override
    public int getBlockAt(GeyserSession session, int x, int y, int z) {
        Player bukkitPlayer = Bukkit.getPlayer((String)session.getPlayerEntity().getUsername());
        if (bukkitPlayer == null) {
            return 0;
        }
        World world = bukkitPlayer.getWorld();
        if (!world.isChunkLoaded(x >> 4, z >> 4)) {
            return 0;
        }
        return this.getBlockNetworkId(world.getBlockAt(x, y, z));
    }

    public int getBlockNetworkId(Block block) {
        if (SchedulerUtils.FOLIA && !Bukkit.isOwnedByCurrentRegion((Block)block)) {
            CompletableFuture blockData = new CompletableFuture();
            Bukkit.getRegionScheduler().execute(this.plugin, block.getLocation(), () -> blockData.complete(block.getBlockData().getAsString()));
            return BlockRegistries.JAVA_IDENTIFIER_TO_ID.getOrDefault((String)blockData.join(), 0);
        }
        return BlockRegistries.JAVA_IDENTIFIER_TO_ID.getOrDefault(block.getBlockData().getAsString(), 0);
    }

    @Override
    public boolean hasOwnChunkCache() {
        return true;
    }

    @Override
    public void sendLecternData(GeyserSession session, int x, int y, int z) {
        Player bukkitPlayer = Bukkit.getPlayer((String)session.getPlayerEntity().getUsername());
        if (bukkitPlayer == null) {
            return;
        }
        Block block = bukkitPlayer.getWorld().getBlockAt(x, y, z);
        SchedulerUtils.runTask(this.plugin, () -> this.sendLecternData(session, block, false), block);
    }

    @Override
    public void sendLecternData(GeyserSession session, int x, int z, List<BlockEntityInfo> blockEntityInfos) {
        Player bukkitPlayer = Bukkit.getPlayer((String)session.getPlayerEntity().getUsername());
        if (bukkitPlayer == null) {
            return;
        }
        if (SchedulerUtils.FOLIA) {
            Chunk chunk = this.getChunk(bukkitPlayer.getWorld(), x, z);
            if (chunk == null) {
                return;
            }
            Bukkit.getRegionScheduler().execute(this.plugin, bukkitPlayer.getWorld(), x, z, () -> this.sendLecternData(session, chunk, blockEntityInfos));
        } else {
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                Chunk chunk = this.getChunk(bukkitPlayer.getWorld(), x, z);
                if (chunk == null) {
                    return;
                }
                this.sendLecternData(session, chunk, blockEntityInfos);
            });
        }
    }

    private @Nullable Chunk getChunk(World world, int x, int z) {
        if (!world.isChunkLoaded(x, z)) {
            return null;
        }
        return world.getChunkAt(x, z);
    }

    private void sendLecternData(GeyserSession session, Chunk chunk, List<BlockEntityInfo> blockEntityInfos) {
        for (int i = 0; i < blockEntityInfos.size(); ++i) {
            BlockEntityInfo info = blockEntityInfos.get(i);
            Block block = chunk.getBlock(info.getX(), info.getY(), info.getZ());
            this.sendLecternData(session, block, true);
        }
    }

    private void sendLecternData(GeyserSession session, Block block, boolean isChunkLoad) {
        NbtMap blockEntityTag = this.lecterns.getLecternData(block, isChunkLoad);
        if (blockEntityTag != null) {
            BlockEntityUtils.updateBlockEntity(session, blockEntityTag, BukkitUtils.getVector(block.getLocation()));
        }
    }

    @Override
    public boolean shouldExpectLecternHandled(GeyserSession session) {
        return true;
    }

    @Override
    public boolean getGameRuleBool(GeyserSession session, org.geysermc.geyser.level.GameRule gameRule) {
        GameRule bukkitGameRule = GameRule.getByName((String)gameRule.getJavaID());
        if (bukkitGameRule == null) {
            GeyserImpl.getInstance().getLogger().debug("Unknown game rule " + gameRule.getJavaID());
            return gameRule.getDefaultBooleanValue();
        }
        Player bukkitPlayer = Objects.requireNonNull(Bukkit.getPlayer((UUID)session.getPlayerEntity().getUuid()));
        Object value = bukkitPlayer.getWorld().getGameRuleValue(bukkitGameRule);
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return booleanValue;
        }
        GeyserImpl.getInstance().getLogger().debug("Expected a bool for " + gameRule + " but got " + value);
        return gameRule.getDefaultBooleanValue();
    }

    @Override
    public int getGameRuleInt(GeyserSession session, org.geysermc.geyser.level.GameRule gameRule) {
        GameRule bukkitGameRule = GameRule.getByName((String)gameRule.getJavaID());
        if (bukkitGameRule == null) {
            GeyserImpl.getInstance().getLogger().debug("Unknown game rule " + gameRule.getJavaID());
            return gameRule.getDefaultIntValue();
        }
        Player bukkitPlayer = Objects.requireNonNull(Bukkit.getPlayer((UUID)session.getPlayerEntity().getUuid()));
        Object value = bukkitPlayer.getWorld().getGameRuleValue(bukkitGameRule);
        if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            return intValue;
        }
        GeyserImpl.getInstance().getLogger().debug("Expected an int for " + gameRule + " but got " + value);
        return gameRule.getDefaultIntValue();
    }

    @Override
    public GameMode getDefaultGameMode(GeyserSession session) {
        return GameMode.byId(Bukkit.getDefaultGameMode().ordinal());
    }

    @Override
    public boolean hasPermission(GeyserSession session, String permission) {
        Player player = Bukkit.getPlayer((UUID)session.javaUuid());
        if (player != null) {
            return player.hasPermission(permission);
        }
        return false;
    }

    @Override
    public @NonNull CompletableFuture<@Nullable DataComponents> getPickItemComponents(GeyserSession session, int x, int y, int z, boolean addNbtData) {
        CompletableFuture<@Nullable DataComponents> future = new CompletableFuture<DataComponents>();
        Player bukkitPlayer = Bukkit.getPlayer((UUID)session.getPlayerEntity().getUuid());
        if (bukkitPlayer == null) {
            future.complete(null);
            return future;
        }
        Block block = bukkitPlayer.getWorld().getBlockAt(x, y, z);
        SchedulerUtils.runTask(this.plugin, () -> future.complete(null), block);
        return future;
    }

    public boolean isLegacy() {
        return false;
    }
}

