/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.ScoreInfo;
import org.cloudburstmc.protocol.bedrock.data.command.CommandEnumConstraint;
import org.cloudburstmc.protocol.bedrock.packet.RemoveObjectivePacket;
import org.cloudburstmc.protocol.bedrock.packet.SetDisplayObjectivePacket;
import org.cloudburstmc.protocol.bedrock.packet.SetScorePacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.Score;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.scoreboard.UpdateType;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ScoreboardPosition;
import org.jetbrains.annotations.Contract;

public final class Scoreboard {
    private static final boolean SHOW_SCOREBOARD_LOGS = Boolean.parseBoolean(System.getProperty("Geyser.ShowScoreboardLogs", "true"));
    private static final boolean ADD_TEAM_SUGGESTIONS = Boolean.parseBoolean(System.getProperty("Geyser.AddTeamSuggestions", "true"));
    private final GeyserSession session;
    private final GeyserLogger logger;
    private final AtomicLong nextId = new AtomicLong(0L);
    private final Map<String, Objective> objectives = new ConcurrentHashMap<String, Objective>();
    private final Map<ScoreboardPosition, Objective> objectiveSlots = new EnumMap<ScoreboardPosition, Objective>(ScoreboardPosition.class);
    private final Map<String, Team> teams = new ConcurrentHashMap<String, Team>();
    private final Map<String, Team> playerToTeam = new Object2ObjectOpenHashMap<String, Team>();
    private int lastAddScoreCount = 0;
    private int lastRemoveScoreCount = 0;

    public Scoreboard(GeyserSession session) {
        this.session = session;
        this.logger = GeyserImpl.getInstance().getLogger();
    }

    public void removeScoreboard() {
        Iterator<Objective> iterator = this.objectives.values().iterator();
        while (iterator.hasNext()) {
            Objective objective = iterator.next();
            iterator.remove();
            this.deleteObjective(objective, false);
        }
    }

    public @Nullable Objective registerNewObjective(String objectiveId) {
        Objective objective = this.objectives.get(objectiveId);
        if (objective != null) {
            if (objective.getUpdateType() != UpdateType.REMOVE) {
                return null;
            }
            this.deleteObjective(objective, true);
        }
        objective = new Objective(this, objectiveId);
        this.objectives.put(objectiveId, objective);
        return objective;
    }

    public void displayObjective(String objectiveId, ScoreboardPosition displaySlot) {
        Objective storedObjective;
        Objective objective = this.objectives.get(objectiveId);
        if (objective == null) {
            return;
        }
        if (!objective.isActive()) {
            objective.setActive(displaySlot);
            objective.setUpdateType(UpdateType.ADD);
        }
        if ((storedObjective = this.objectiveSlots.get((Object)displaySlot)) != null && storedObjective != objective) {
            storedObjective.pendingRemove();
        }
        this.objectiveSlots.put(displaySlot, objective);
        if (displaySlot == ScoreboardPosition.BELOW_NAME) {
            for (PlayerEntity entity : this.session.getEntityCache().getAllPlayerEntities()) {
                if (!entity.isValid()) continue;
                entity.setBelowNameText(objective);
            }
        }
    }

    public Team registerNewTeam(String teamName, String[] players) {
        Team team = this.teams.get(teamName);
        if (team != null) {
            if (SHOW_SCOREBOARD_LOGS) {
                this.logger.info(GeyserLocale.getLocaleStringLog("geyser.network.translator.team.failed_overrides", teamName));
            }
            return team;
        }
        team = new Team(this, teamName);
        team.addEntities(players);
        this.teams.put(teamName, team);
        if (ADD_TEAM_SUGGESTIONS) {
            this.session.addCommandEnum("Geyser_Teams", team.getId());
        }
        return team;
    }

    public void onUpdate() {
        SetScorePacket setScorePacket;
        ArrayList<ScoreInfo> addScores = new ArrayList<ScoreInfo>(this.lastAddScoreCount);
        ArrayList<ScoreInfo> removeScores = new ArrayList<ScoreInfo>(this.lastRemoveScoreCount);
        ArrayList<Objective> removedObjectives = new ArrayList<Objective>();
        Team playerTeam = this.getTeamFor(this.session.getPlayerEntity().getUsername());
        Objective correctSidebar = null;
        for (Objective objective : this.objectives.values()) {
            if (objective.getUpdateType() == UpdateType.REMOVE) {
                removedObjectives.add(objective);
                continue;
            }
            if (!objective.isActive() || playerTeam == null || playerTeam.getColor() != objective.getTeamColor()) continue;
            correctSidebar = objective;
        }
        if (correctSidebar == null) {
            correctSidebar = this.objectiveSlots.get((Object)ScoreboardPosition.SIDEBAR);
        }
        for (Objective objective : removedObjectives) {
            this.deleteObjective(objective, true);
        }
        this.handleObjective(this.objectiveSlots.get((Object)ScoreboardPosition.PLAYER_LIST), addScores, removeScores);
        this.handleObjective(correctSidebar, addScores, removeScores);
        this.handleObjective(this.objectiveSlots.get((Object)ScoreboardPosition.BELOW_NAME), addScores, removeScores);
        Iterator<Team> teamIterator = this.teams.values().iterator();
        while (teamIterator.hasNext()) {
            Team current = teamIterator.next();
            switch (current.getCachedUpdateType()) {
                case ADD: 
                case UPDATE: {
                    current.markUpdated();
                    break;
                }
                case REMOVE: {
                    teamIterator.remove();
                }
            }
        }
        if (!removeScores.isEmpty()) {
            setScorePacket = new SetScorePacket();
            setScorePacket.setAction(SetScorePacket.Action.REMOVE);
            setScorePacket.setInfos(removeScores);
            this.session.sendUpstreamPacket(setScorePacket);
        }
        if (!addScores.isEmpty()) {
            setScorePacket = new SetScorePacket();
            setScorePacket.setAction(SetScorePacket.Action.SET);
            setScorePacket.setInfos(addScores);
            this.session.sendUpstreamPacket(setScorePacket);
        }
        this.lastAddScoreCount = addScores.size();
        this.lastRemoveScoreCount = removeScores.size();
    }

    private void handleObjective(Objective objective, List<ScoreInfo> addScores, List<ScoreInfo> removeScores) {
        if (objective == null || objective.getUpdateType() == UpdateType.REMOVE) {
            return;
        }
        if (objective.getType() == 1) {
            for (Score score : objective.getScores().values()) {
                boolean update = score.shouldUpdate();
                if (update) {
                    score.update(objective);
                }
                if (score.getUpdateType() != UpdateType.REMOVE && update) {
                    addScores.add(score.getCachedInfo());
                }
                if (score.getUpdateType() == UpdateType.ADD || !update) continue;
                removeScores.add(score.getCachedInfo());
            }
            return;
        }
        boolean objectiveAdd = objective.getUpdateType() == UpdateType.ADD;
        boolean objectiveUpdate = objective.getUpdateType() == UpdateType.UPDATE;
        for (Score score : objective.getScores().values()) {
            boolean add;
            if (score.getUpdateType() == UpdateType.REMOVE) {
                ScoreInfo cachedInfo = score.getCachedInfo();
                if (cachedInfo != null) {
                    removeScores.add(cachedInfo);
                }
                objective.removeScore0(score.getName());
                break;
            }
            Team team = score.getTeam();
            boolean bl = add = objectiveAdd || objectiveUpdate;
            if (!(team == null || team.getUpdateType() != UpdateType.REMOVE && team.hasEntity(score.getName()))) {
                score.setTeam(null);
                add = true;
            }
            if (score.shouldUpdate()) {
                score.update(objective);
                add = true;
            }
            if (add) {
                addScores.add(score.getCachedInfo());
            }
            if (add && score.getUpdateType() != UpdateType.ADD && !objectiveUpdate && !objectiveAdd) {
                removeScores.add(score.getCachedInfo());
            }
            score.setUpdateType(UpdateType.NOTHING);
        }
        if (objectiveUpdate) {
            RemoveObjectivePacket removeObjectivePacket = new RemoveObjectivePacket();
            removeObjectivePacket.setObjectiveId(objective.getObjectiveName());
            this.session.sendUpstreamPacket(removeObjectivePacket);
        }
        if (objectiveAdd || objectiveUpdate) {
            SetDisplayObjectivePacket displayObjectivePacket = new SetDisplayObjectivePacket();
            displayObjectivePacket.setObjectiveId(objective.getObjectiveName());
            displayObjectivePacket.setDisplayName(objective.getDisplayName());
            displayObjectivePacket.setCriteria("dummy");
            displayObjectivePacket.setDisplaySlot(objective.getDisplaySlotName());
            displayObjectivePacket.setSortOrder(1);
            this.session.sendUpstreamPacket(displayObjectivePacket);
        }
        objective.setUpdateType(UpdateType.NOTHING);
    }

    public void deleteObjective(Objective objective, boolean remove) {
        if (remove) {
            this.objectives.remove(objective.getObjectiveName());
        }
        this.objectiveSlots.remove((Object)objective.getDisplaySlot(), objective);
        objective.removed();
        RemoveObjectivePacket removeObjectivePacket = new RemoveObjectivePacket();
        removeObjectivePacket.setObjectiveId(objective.getObjectiveName());
        this.session.sendUpstreamPacket(removeObjectivePacket);
    }

    public Objective getObjective(String objectiveName) {
        return this.objectives.get(objectiveName);
    }

    public Collection<Objective> getObjectives() {
        return this.objectives.values();
    }

    public void unregisterObjective(String objectiveName) {
        Objective objective = this.getObjective(objectiveName);
        if (objective != null) {
            objective.pendingRemove();
        }
    }

    public Objective getSlot(ScoreboardPosition slot) {
        return this.objectiveSlots.get((Object)slot);
    }

    public Team getTeam(String teamName) {
        return this.teams.get(teamName);
    }

    public Team getTeamFor(String entity) {
        return this.playerToTeam.get(entity);
    }

    public void removeTeam(String teamName) {
        Team remove = this.teams.remove(teamName);
        if (remove != null) {
            remove.setUpdateType(UpdateType.REMOVE);
            this.updateEntityNames(remove, remove.getEntities(), true);
            for (String name : remove.getEntities()) {
                this.playerToTeam.remove(name);
            }
            this.session.removeCommandEnum("Geyser_Teams", remove.getId());
        }
    }

    @Contract(value="-> new")
    public Map<String, Set<CommandEnumConstraint>> getTeamNames() {
        return this.teams.keySet().stream().collect(Collectors.toMap(Function.identity(), o -> EnumSet.noneOf(CommandEnumConstraint.class), (o1, o2) -> o1, LinkedHashMap::new));
    }

    public void updateEntityNames(Team team, boolean teamChange) {
        HashSet<String> names = new HashSet<String>(team.getEntities());
        this.updateEntityNames(team, names, teamChange);
    }

    public void updateEntityNames(@Nullable Team team, Set<String> names, boolean teamChange) {
        if (names.remove(this.session.getPlayerEntity().getUsername()) && teamChange) {
            this.refreshSessionPlayerDisplays();
        }
        if (!names.isEmpty()) {
            for (Entity entity : this.session.getEntityCache().getEntities().values()) {
                PlayerEntity player;
                if (!(entity instanceof PlayerEntity) || !names.remove((player = (PlayerEntity)entity).getUsername())) continue;
                player.updateDisplayName(team);
                player.updateBedrockMetadata();
                if (!names.isEmpty()) continue;
                break;
            }
        }
    }

    private void refreshSessionPlayerDisplays() {
        for (Entity entity : this.session.getEntityCache().getEntities().values()) {
            if (!(entity instanceof PlayerEntity)) continue;
            PlayerEntity player = (PlayerEntity)entity;
            Team playerTeam = this.session.getWorldCache().getScoreboard().getTeamFor(player.getUsername());
            player.updateDisplayName(playerTeam);
            player.updateBedrockMetadata();
        }
    }

    public AtomicLong getNextId() {
        return this.nextId;
    }

    public Map<ScoreboardPosition, Objective> getObjectiveSlots() {
        return this.objectiveSlots;
    }

    public Map<String, Team> getPlayerToTeam() {
        return this.playerToTeam;
    }
}

