/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.cloudburstmc.protocol.bedrock.data.TrimMaterial;
import org.cloudburstmc.protocol.bedrock.data.TrimPattern;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.living.animal.tameable.WolfEntity;
import org.geysermc.geyser.inventory.item.BannerPattern;
import org.geysermc.geyser.inventory.recipe.TrimRecipe;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2IntMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistry;
import org.geysermc.geyser.session.cache.registry.SimpleJavaRegistry;
import org.geysermc.geyser.text.TextDecoration;
import org.geysermc.geyser.translator.level.BiomeTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.RegistryEntry;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundRegistryDataPacket;

public final class RegistryCache {
    private static final Map<String, BiConsumer<RegistryCache, List<RegistryEntry>>> REGISTRIES = new HashMap<String, BiConsumer<RegistryCache, List<RegistryEntry>>>();
    private final GeyserSession session;
    private int[] biomeTranslations;
    private final JavaRegistry<TextDecoration> chatTypes = new SimpleJavaRegistry<TextDecoration>();
    private final JavaRegistry<JavaDimension> dimensions = new SimpleJavaRegistry<JavaDimension>();
    private final JavaRegistry<TrimMaterial> trimMaterials = new SimpleJavaRegistry<TrimMaterial>();
    private final JavaRegistry<TrimPattern> trimPatterns = new SimpleJavaRegistry<TrimPattern>();
    private final JavaRegistry<BannerPattern> bannerPatterns = new SimpleJavaRegistry<BannerPattern>();
    private final JavaRegistry<WolfEntity.WolfVariant> wolfVariants = new SimpleJavaRegistry<WolfEntity.WolfVariant>();

    public RegistryCache(GeyserSession session) {
        this.session = session;
    }

    public void load(ClientboundRegistryDataPacket packet) {
        BiConsumer<RegistryCache, List<RegistryEntry>> reader = REGISTRIES.get(packet.getRegistry());
        if (reader != null) {
            reader.accept(this, packet.getEntries());
        } else {
            GeyserImpl.getInstance().getLogger().debug("Ignoring registry of type " + packet.getRegistry());
        }
    }

    private static <T> void register(String registry, Function<RegistryCache, JavaRegistry<T>> localCacheFunction, BiFunction<GeyserSession, RegistryEntry, T> reader) {
        REGISTRIES.put("minecraft:" + registry, (registryCache, entries) -> {
            JavaRegistry localCache = (JavaRegistry)localCacheFunction.apply((RegistryCache)registryCache);
            ArrayList builder = new ArrayList(entries.size());
            for (int i = 0; i < entries.size(); ++i) {
                RegistryEntry entry = (RegistryEntry)entries.get(i);
                Object cacheEntry = reader.apply(registryCache.session, entry);
                builder.add(i, cacheEntry);
            }
            localCache.reset(builder);
        });
    }

    private static void register(String registry, BiConsumer<RegistryCache, int[]> localCacheFunction, ToIntFunction<RegistryEntry> reader) {
        REGISTRIES.put("minecraft:" + registry, (registryCache, entries) -> {
            Int2IntOpenHashMap temp = new Int2IntOpenHashMap();
            int greatestId = 0;
            for (int i = 0; i < entries.size(); ++i) {
                RegistryEntry entry = (RegistryEntry)entries.get(i);
                int cacheEntry = reader.applyAsInt(entry);
                temp.put(i, cacheEntry);
                if (i <= greatestId) continue;
                greatestId = i;
            }
            int[] array = new int[greatestId + 1];
            for (Int2IntMap.Entry entry : temp.int2IntEntrySet()) {
                array[entry.getIntKey()] = entry.getIntValue();
            }
            localCacheFunction.accept((RegistryCache)registryCache, array);
        });
    }

    public int[] biomeTranslations() {
        return this.biomeTranslations;
    }

    public JavaRegistry<TextDecoration> chatTypes() {
        return this.chatTypes;
    }

    public JavaRegistry<JavaDimension> dimensions() {
        return this.dimensions;
    }

    public JavaRegistry<TrimMaterial> trimMaterials() {
        return this.trimMaterials;
    }

    public JavaRegistry<TrimPattern> trimPatterns() {
        return this.trimPatterns;
    }

    public JavaRegistry<BannerPattern> bannerPatterns() {
        return this.bannerPatterns;
    }

    public JavaRegistry<WolfEntity.WolfVariant> wolfVariants() {
        return this.wolfVariants;
    }

    static {
        RegistryCache.register("chat_type", (RegistryCache cache) -> cache.chatTypes, (GeyserSession $, RegistryEntry entry) -> TextDecoration.readChatType(entry));
        RegistryCache.register("dimension_type", (RegistryCache cache) -> cache.dimensions, (GeyserSession $, RegistryEntry entry) -> JavaDimension.read(entry));
        RegistryCache.register("trim_material", (RegistryCache cache) -> cache.trimMaterials, TrimRecipe::readTrimMaterial);
        RegistryCache.register("trim_pattern", (RegistryCache cache) -> cache.trimPatterns, TrimRecipe::readTrimPattern);
        RegistryCache.register("worldgen/biome", (RegistryCache cache, int[] array) -> {
            cache.biomeTranslations = array;
        }, BiomeTranslator::loadServerBiome);
        RegistryCache.register("banner_pattern", (RegistryCache cache) -> cache.bannerPatterns, (GeyserSession $, RegistryEntry entry) -> BannerPattern.getByJavaIdentifier(entry.getId()));
        RegistryCache.register("wolf_variant", (RegistryCache cache) -> cache.wolfVariants, (GeyserSession $, RegistryEntry entry) -> WolfEntity.WolfVariant.getByJavaIdentifier(entry.getId()));
    }
}

