/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.packet.SetTitlePacket;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntMaps;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.mcprotocollib.protocol.data.game.setting.Difficulty;

public final class WorldCache {
    private final GeyserSession session;
    private final ScoreboardUpdater.ScoreboardSession scoreboardSession;
    private Scoreboard scoreboard;
    private Difficulty difficulty = Difficulty.EASY;
    private boolean titleTimesNeedReset = false;
    private int trueTitleFadeInTime;
    private int trueTitleStayTime;
    private int trueTitleFadeOutTime;
    private int currentSequence;
    private final Object2IntMap<Vector3i> unverifiedPredictions = new Object2IntOpenHashMap<Vector3i>(1);
    private boolean editingSignOnFront;

    public WorldCache(GeyserSession session) {
        this.session = session;
        this.scoreboard = new Scoreboard(session);
        this.scoreboardSession = new ScoreboardUpdater.ScoreboardSession(session);
        this.resetTitleTimes(false);
    }

    public void removeScoreboard() {
        if (this.scoreboard != null) {
            this.scoreboard.removeScoreboard();
            this.scoreboard = new Scoreboard(this.session);
        }
    }

    public int increaseAndGetScoreboardPacketsPerSecond() {
        int pendingPps = this.scoreboardSession.getPendingPacketsPerSecond().incrementAndGet();
        int pps = this.scoreboardSession.getPacketsPerSecond();
        return Math.max(pps, pendingPps);
    }

    public void markTitleTimesAsIncorrect() {
        this.titleTimesNeedReset = true;
    }

    public void setTitleTimes(int fadeInTime, int stayTime, int fadeOutTime) {
        this.trueTitleFadeInTime = fadeInTime;
        this.trueTitleStayTime = stayTime;
        this.trueTitleFadeOutTime = fadeOutTime;
        this.titleTimesNeedReset = false;
    }

    public void synchronizeCorrectTitleTimes() {
        if (this.titleTimesNeedReset) {
            this.forceSyncCorrectTitleTimes();
        }
    }

    private void forceSyncCorrectTitleTimes() {
        SetTitlePacket titlePacket = new SetTitlePacket();
        titlePacket.setType(SetTitlePacket.Type.TIMES);
        titlePacket.setText("");
        titlePacket.setFadeInTime(this.trueTitleFadeInTime);
        titlePacket.setStayTime(this.trueTitleStayTime);
        titlePacket.setFadeOutTime(this.trueTitleFadeOutTime);
        titlePacket.setPlatformOnlineId("");
        titlePacket.setXuid("");
        this.session.sendUpstreamPacket(titlePacket);
        this.titleTimesNeedReset = false;
    }

    public void resetTitleTimes(boolean clientSync) {
        this.trueTitleFadeInTime = 10;
        this.trueTitleStayTime = 70;
        this.trueTitleFadeOutTime = 20;
        if (clientSync) {
            this.forceSyncCorrectTitleTimes();
        }
    }

    public int nextPredictionSequence() {
        return ++this.currentSequence;
    }

    public void markPositionInSequence(Vector3i position) {
        if (this.session.isEmulatePost1_18Logic()) {
            this.unverifiedPredictions.put(position, this.currentSequence);
        }
    }

    public void updateServerCorrectBlockState(Vector3i position, int blockState) {
        if (!this.unverifiedPredictions.isEmpty()) {
            this.unverifiedPredictions.removeInt(position);
        }
        ChunkUtils.updateBlock(this.session, blockState, position);
    }

    public void endPredictionsUpTo(int sequence) {
        if (this.unverifiedPredictions.isEmpty()) {
            return;
        }
        ObjectIterator<Object2IntMap.Entry<Vector3i>> it = Object2IntMaps.fastIterator(this.unverifiedPredictions);
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            if (entry.getIntValue() > sequence) continue;
            Vector3i position = (Vector3i)entry.getKey();
            ChunkUtils.updateBlockClientSide(this.session, this.session.getGeyser().getWorldManager().getBlockAt(this.session, position), position);
            it.remove();
        }
    }

    public ScoreboardUpdater.ScoreboardSession getScoreboardSession() {
        return this.scoreboardSession;
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public boolean isEditingSignOnFront() {
        return this.editingSignOnFront;
    }

    public void setEditingSignOnFront(boolean editingSignOnFront) {
        this.editingSignOnFront = editingSignOnFront;
    }
}

