/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.util.AssetUtils;

public final class ProvidedSkins {
    private static final ProvidedSkin[] PROVIDED_SKINS = new ProvidedSkin[]{new ProvidedSkin("textures/entity/player/slim/alex.png", true), new ProvidedSkin("textures/entity/player/slim/ari.png", true), new ProvidedSkin("textures/entity/player/slim/efe.png", true), new ProvidedSkin("textures/entity/player/slim/kai.png", true), new ProvidedSkin("textures/entity/player/slim/makena.png", true), new ProvidedSkin("textures/entity/player/slim/noor.png", true), new ProvidedSkin("textures/entity/player/slim/steve.png", true), new ProvidedSkin("textures/entity/player/slim/sunny.png", true), new ProvidedSkin("textures/entity/player/slim/zuri.png", true), new ProvidedSkin("textures/entity/player/wide/alex.png", false), new ProvidedSkin("textures/entity/player/wide/ari.png", false), new ProvidedSkin("textures/entity/player/wide/efe.png", false), new ProvidedSkin("textures/entity/player/wide/kai.png", false), new ProvidedSkin("textures/entity/player/wide/makena.png", false), new ProvidedSkin("textures/entity/player/wide/noor.png", false), new ProvidedSkin("textures/entity/player/wide/steve.png", false), new ProvidedSkin("textures/entity/player/wide/sunny.png", false), new ProvidedSkin("textures/entity/player/wide/zuri.png", false)};

    public static ProvidedSkin getDefaultPlayerSkin(UUID uuid) {
        return PROVIDED_SKINS[Math.floorMod(uuid.hashCode(), PROVIDED_SKINS.length)];
    }

    private ProvidedSkins() {
    }

    public static void init() {
    }

    static {
        Path folder = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache").resolve("default_player_skins");
        folder.toFile().mkdirs();
        folder.resolve("slim").toFile().mkdir();
        folder.resolve("wide").toFile().mkdir();
    }

    public static final class ProvidedSkin {
        private SkinProvider.Skin data;
        private final boolean slim;

        ProvidedSkin(String asset, boolean slim) {
            this.slim = slim;
            Path folder = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache").resolve("default_player_skins").resolve(slim ? "slim" : "wide");
            String assetName = asset.substring(asset.lastIndexOf(47) + 1);
            Path location = folder.resolve(assetName);
            AssetUtils.addTask(!Files.exists(location, new LinkOption[0]), new AssetUtils.ClientJarTask("assets/minecraft/" + asset, stream -> AssetUtils.saveFile(location, stream), () -> {
                try {
                    BufferedImage image;
                    try (InputStream stream = Files.newInputStream(location, new OpenOption[0]);){
                        image = ImageIO.read(stream);
                    }
                    byte[] byteData = SkinProvider.bufferedImageToImageData(image);
                    image.flush();
                    String identifier = "geysermc:" + assetName + "_" + (slim ? "slim" : "wide");
                    this.data = new SkinProvider.Skin(-1L, identifier, byteData);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }));
        }

        public SkinProvider.Skin getData() {
            return Objects.requireNonNullElse(this.data, SkinProvider.EMPTY_SKIN);
        }

        public boolean isSlim() {
            return this.slim;
        }
    }
}

