/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftLoomAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftResultsDeprecatedAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.item.type.BannerItem;
import org.geysermc.geyser.item.type.DyeItem;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BannerPatternLayer;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;

public class LoomInventoryTranslator
extends AbstractBlockInventoryTranslator {
    private static final Object2IntMap<String> PATTERN_TO_INDEX = new Object2IntOpenHashMap<String>();

    public LoomInventoryTranslator() {
        super(4, "minecraft:loom[facing=north]", ContainerType.LOOM, UIInventoryUpdater.INSTANCE, new String[0]);
    }

    @Override
    protected boolean shouldRejectItemPlace(GeyserSession session, Inventory inventory, ContainerSlotType bedrockSourceContainer, int javaSourceSlot, ContainerSlotType bedrockDestinationContainer, int javaDestinationSlot) {
        GeyserItemStack itemStack;
        if (javaDestinationSlot != 1) {
            return false;
        }
        GeyserItemStack geyserItemStack = itemStack = javaSourceSlot == -1 ? session.getPlayerInventory().getCursor() : inventory.getItem(javaSourceSlot);
        if (itemStack.isEmpty()) {
            return false;
        }
        return !(itemStack.asItem() instanceof DyeItem);
    }

    @Override
    protected boolean shouldHandleRequestFirst(ItemStackRequestAction action, Inventory inventory) {
        return action.getType() == ItemStackRequestActionType.CRAFT_LOOM && inventory.getItem(2).isEmpty();
    }

    @Override
    public ItemStackResponse translateSpecialRequest(GeyserSession session, Inventory inventory, ItemStackRequest request) {
        BannerPatternLayer bannerPatternLayer;
        ItemStackRequestAction headerData = request.getActions()[0];
        ItemStackRequestAction data = request.getActions()[1];
        if (!(headerData instanceof CraftLoomAction)) {
            return LoomInventoryTranslator.rejectRequest(request);
        }
        if (!(data instanceof CraftResultsDeprecatedAction)) {
            return LoomInventoryTranslator.rejectRequest(request);
        }
        CraftResultsDeprecatedAction craftData = (CraftResultsDeprecatedAction)data;
        List<NbtMap> newBlockEntityTag = craftData.getResultItems()[0].getTag().getList("Patterns", NbtType.COMPOUND);
        NbtMap pattern = newBlockEntityTag.get(newBlockEntityTag.size() - 1);
        String bedrockPattern = ((CraftLoomAction)headerData).getPatternId();
        int index = PATTERN_TO_INDEX.getOrDefault((Object)bedrockPattern, -1);
        if (index == -1) {
            return LoomInventoryTranslator.rejectRequest(request);
        }
        ServerboundContainerButtonClickPacket packet = new ServerboundContainerButtonClickPacket(inventory.getJavaId(), index);
        session.sendDownstreamGamePacket(packet);
        GeyserItemStack inputCopy = inventory.getItem(0).copy(1);
        inputCopy.setNetId(session.getNextItemNetId());
        if (inputCopy.getComponents() == null) {
            inputCopy.setComponents(new DataComponents(new HashMap()));
        }
        if ((bannerPatternLayer = BannerItem.getJavaBannerPattern(session, pattern)) != null) {
            List patternsList = inputCopy.getComponents().getOrDefault(DataComponentType.BANNER_PATTERNS, new ArrayList());
            patternsList.add(bannerPatternLayer);
            inputCopy.getComponents().put(DataComponentType.BANNER_PATTERNS, patternsList);
        }
        inventory.setItem(3, inputCopy, session);
        return this.translateRequest(session, inventory, request);
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        return switch (slotInfoData.getContainer()) {
            case ContainerSlotType.LOOM_INPUT -> 0;
            case ContainerSlotType.LOOM_DYE -> 1;
            case ContainerSlotType.LOOM_MATERIAL -> 2;
            case ContainerSlotType.LOOM_RESULT, ContainerSlotType.CREATED_OUTPUT -> 3;
            default -> super.bedrockSlotToJava(slotInfoData);
        };
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        return switch (slot) {
            case 0 -> new BedrockContainerSlot(ContainerSlotType.LOOM_INPUT, 9);
            case 1 -> new BedrockContainerSlot(ContainerSlotType.LOOM_DYE, 10);
            case 2 -> new BedrockContainerSlot(ContainerSlotType.LOOM_MATERIAL, 11);
            case 3 -> new BedrockContainerSlot(ContainerSlotType.LOOM_RESULT, 50);
            default -> super.javaSlotToBedrockContainer(slot);
        };
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        return switch (slot) {
            case 0 -> 9;
            case 1 -> 10;
            case 2 -> 11;
            case 3 -> 50;
            default -> super.javaSlotToBedrock(slot);
        };
    }

    @Override
    public SlotType getSlotType(int javaSlot) {
        if (javaSlot == 3) {
            return SlotType.OUTPUT;
        }
        return super.getSlotType(javaSlot);
    }

    static {
        int index = 0;
        PATTERN_TO_INDEX.put("bl", index++);
        PATTERN_TO_INDEX.put("br", index++);
        PATTERN_TO_INDEX.put("tl", index++);
        PATTERN_TO_INDEX.put("tr", index++);
        PATTERN_TO_INDEX.put("bs", index++);
        PATTERN_TO_INDEX.put("ts", index++);
        PATTERN_TO_INDEX.put("ls", index++);
        PATTERN_TO_INDEX.put("rs", index++);
        PATTERN_TO_INDEX.put("cs", index++);
        PATTERN_TO_INDEX.put("ms", index++);
        PATTERN_TO_INDEX.put("drs", index++);
        PATTERN_TO_INDEX.put("dls", index++);
        PATTERN_TO_INDEX.put("ss", index++);
        PATTERN_TO_INDEX.put("cr", index++);
        PATTERN_TO_INDEX.put("sc", index++);
        PATTERN_TO_INDEX.put("bt", index++);
        PATTERN_TO_INDEX.put("tt", index++);
        PATTERN_TO_INDEX.put("bts", index++);
        PATTERN_TO_INDEX.put("tts", index++);
        PATTERN_TO_INDEX.put("ld", index++);
        PATTERN_TO_INDEX.put("rd", index++);
        PATTERN_TO_INDEX.put("lud", index++);
        PATTERN_TO_INDEX.put("rud", index++);
        PATTERN_TO_INDEX.put("mc", index++);
        PATTERN_TO_INDEX.put("mr", index++);
        PATTERN_TO_INDEX.put("vh", index++);
        PATTERN_TO_INDEX.put("hh", index++);
        PATTERN_TO_INDEX.put("vhr", index++);
        PATTERN_TO_INDEX.put("hhb", index++);
        PATTERN_TO_INDEX.put("bo", index++);
        int n = ++index;
        PATTERN_TO_INDEX.put("gra", n);
        PATTERN_TO_INDEX.put("gru", ++index);
    }
}

