/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.item;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.registry.type.ItemMapping;

public final class BedrockItemBuilder {
    private @Nullable String customName;
    private @Nullable List<String> lore;
    private OptionalInt damage = OptionalInt.empty();
    private @Nullable NbtMapBuilder builder;

    public @Nullable String getCustomName() {
        return this.customName;
    }

    public BedrockItemBuilder setCustomName(String customName) {
        this.customName = customName;
        return this;
    }

    public @NonNull List<String> getOrCreateLore() {
        if (this.lore == null) {
            this.lore = new ArrayList<String>();
        }
        return this.lore;
    }

    public OptionalInt getDamage() {
        return this.damage;
    }

    public BedrockItemBuilder setDamage(int damage) {
        this.damage = OptionalInt.of(damage);
        return this;
    }

    public @NonNull NbtMapBuilder getOrCreateNbt() {
        if (this.builder == null) {
            this.builder = NbtMap.builder();
        }
        return this.builder;
    }

    public NbtMapBuilder putByte(String name, byte value) {
        return this.getOrCreateNbt().putByte(name, value);
    }

    public NbtMapBuilder putByte(String name, int value) {
        return this.getOrCreateNbt().putByte(name, (byte)value);
    }

    public NbtMapBuilder putInt(String name, int value) {
        return this.getOrCreateNbt().putInt(name, value);
    }

    public <T> NbtMapBuilder putList(String name, NbtType<T> type, List<T> value) {
        return this.getOrCreateNbt().putList(name, type, value);
    }

    public NbtMapBuilder putLong(String name, long value) {
        return this.getOrCreateNbt().putLong(name, value);
    }

    public NbtMapBuilder putString(String name, String value) {
        return this.getOrCreateNbt().putString(name, value);
    }

    public NbtMapBuilder putCompound(String name, NbtMap value) {
        return this.getOrCreateNbt().putCompound(name, value);
    }

    public @Nullable NbtMap build() {
        if (this.customName != null || this.lore != null) {
            NbtMapBuilder display = NbtMap.builder();
            if (this.customName != null) {
                display.putString("Name", this.customName);
            }
            if (this.lore != null) {
                display.putList("Lore", NbtType.STRING, this.lore);
            }
            this.getOrCreateNbt().put("display", (Object)display.build());
        }
        if (this.damage.isPresent()) {
            this.getOrCreateNbt().putInt("Damage", this.damage.getAsInt());
        }
        if (this.builder == null) {
            return null;
        }
        return this.builder.build();
    }

    public static NbtMapBuilder createItemNbt(ItemMapping mapping, int count, int damage) {
        NbtMapBuilder builder = NbtMap.builder();
        builder.putString("Name", mapping.getBedrockIdentifier());
        builder.putByte("Count", (byte)count);
        builder.putShort("Damage", (short)damage);
        return builder;
    }
}

