/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.packet.AnimatePacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundPaddleBoatPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundSwingPacket;

@Translator(packet=AnimatePacket.class)
public class BedrockAnimateTranslator
extends PacketTranslator<AnimatePacket> {
    @Override
    public void translate(GeyserSession session, AnimatePacket packet) {
        if (!session.isSpawned()) {
            return;
        }
        switch (packet.getAction()) {
            case SWING_ARM: {
                session.armSwingPending();
                session.scheduleInEventLoop(() -> {
                    if (session.getArmAnimationTicks() != 0) {
                        session.sendDownstreamGamePacket(new ServerboundSwingPacket(Hand.MAIN_HAND));
                        session.activateArmAnimationTicking();
                    }
                }, 25L, TimeUnit.MILLISECONDS);
                break;
            }
            case ROW_LEFT: {
                session.setSteeringLeft((double)packet.getRowingTime() > 0.0);
                ServerboundPaddleBoatPacket steerLeftPacket = new ServerboundPaddleBoatPacket(session.isSteeringLeft(), session.isSteeringRight());
                session.sendDownstreamGamePacket(steerLeftPacket);
                break;
            }
            case ROW_RIGHT: {
                session.setSteeringRight((double)packet.getRowingTime() > 0.0);
                ServerboundPaddleBoatPacket steerRightPacket = new ServerboundPaddleBoatPacket(session.isSteeringLeft(), session.isSteeringRight());
                session.sendDownstreamGamePacket(steerRightPacket);
            }
        }
    }
}

