/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.packet.BlockPickRequestPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.BlockMapping;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

@Translator(packet=BlockPickRequestPacket.class)
public class BedrockBlockPickRequestTranslator
extends PacketTranslator<BlockPickRequestPacket> {
    @Override
    public void translate(GeyserSession session, BlockPickRequestPacket packet) {
        boolean addExtraData;
        Vector3i vector = packet.getBlockPosition();
        int blockToPick = session.getGeyser().getWorldManager().getBlockAt(session, vector.getX(), vector.getY(), vector.getZ());
        if (blockToPick == 0) {
            ItemFrameEntity entity = ItemFrameEntity.getItemFrameEntity(session, packet.getBlockPosition());
            if (entity != null) {
                if (!InventoryUtils.isEmpty(entity.getHeldItem())) {
                    InventoryUtils.findOrCreateItem(session, entity.getHeldItem());
                } else {
                    InventoryUtils.findOrCreateItem(session, entity.getDefinition() == EntityDefinitions.GLOW_ITEM_FRAME ? "minecraft:glow_item_frame" : "minecraft:item_frame");
                }
            }
            return;
        }
        BlockMapping blockMapping = BlockRegistries.JAVA_BLOCKS.getOrDefault(blockToPick, BlockMapping.DEFAULT);
        boolean bl = addExtraData = packet.isAddUserData() && blockMapping.isBlockEntity();
        if (BlockStateValues.getBannerColor(blockToPick) != -1 || addExtraData) {
            session.getGeyser().getWorldManager().getPickItemComponents(session, vector.getX(), vector.getY(), vector.getZ(), addExtraData).whenComplete((components, ex) -> session.ensureInEventLoop(() -> {
                if (components == null) {
                    this.pickItem(session, blockMapping);
                    return;
                }
                ItemMapping mapping = session.getItemMappings().getMapping(blockMapping.getPickItem());
                ItemStack itemStack = new ItemStack(mapping.getJavaItem().javaId(), 1, (DataComponents)components);
                InventoryUtils.findOrCreateItem(session, itemStack);
            }));
            return;
        }
        this.pickItem(session, blockMapping);
    }

    private void pickItem(GeyserSession session, BlockMapping blockToPick) {
        InventoryUtils.findOrCreateItem(session, blockToPick.getPickItem());
    }
}

