/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetPlayerGameTypePacket;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerSpawnInfo;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundRespawnPacket;

@Translator(packet=ClientboundRespawnPacket.class)
public class JavaRespawnTranslator
extends PacketTranslator<ClientboundRespawnPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundRespawnPacket packet) {
        SessionPlayerEntity entity = session.getPlayerEntity();
        PlayerSpawnInfo spawnInfo = packet.getCommonPlayerSpawnInfo();
        if (!packet.isKeepMetadata()) {
            entity.resetMetadata();
        }
        if (!packet.isKeepAttributes()) {
            entity.resetAttributes();
        }
        session.setSpawned(false);
        entity.setHealth(entity.getMaxHealth());
        entity.getAttributes().put(GeyserAttributeType.HEALTH, entity.createHealthAttribute());
        session.setInventoryTranslator(InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR);
        session.setOpenInventory(null);
        session.setClosingInventory(false);
        entity.setLastDeathPosition(spawnInfo.getLastDeathPos());
        entity.updateBedrockMetadata();
        SetPlayerGameTypePacket playerGameTypePacket = new SetPlayerGameTypePacket();
        playerGameTypePacket.setGamemode(EntityUtils.toBedrockGamemode(spawnInfo.getGameMode()).ordinal());
        session.sendUpstreamPacket(playerGameTypePacket);
        session.setGameMode(spawnInfo.getGameMode());
        if (session.isRaining()) {
            LevelEventPacket stopRainPacket = new LevelEventPacket();
            stopRainPacket.setType(LevelEvent.STOP_RAINING);
            stopRainPacket.setData(0);
            stopRainPacket.setPosition(Vector3f.ZERO);
            session.sendUpstreamPacket(stopRainPacket);
            session.setRaining(false);
        }
        if (session.isThunder()) {
            LevelEventPacket stopThunderPacket = new LevelEventPacket();
            stopThunderPacket.setType(LevelEvent.STOP_THUNDERSTORM);
            stopThunderPacket.setData(0);
            stopThunderPacket.setPosition(Vector3f.ZERO);
            session.sendUpstreamPacket(stopThunderPacket);
            session.setThunder(false);
        }
        int newDimension = spawnInfo.getDimension();
        if (session.getDimension() != newDimension || !spawnInfo.getWorldName().equals(session.getWorldName())) {
            if (DimensionUtils.javaToBedrock(session.getDimension()) == DimensionUtils.javaToBedrock(newDimension)) {
                int fakeDim = DimensionUtils.getTemporaryDimension(session.getDimension(), newDimension);
                DimensionUtils.switchDimension(session, fakeDim);
            }
            session.setWorldName(spawnInfo.getWorldName());
            DimensionUtils.switchDimension(session, newDimension);
            ChunkUtils.loadDimension(session);
        }
    }
}

