/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.GameRuleData;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.GameRulesChangedPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetPlayerGameTypePacket;
import org.cloudburstmc.protocol.bedrock.packet.ShowCreditsPacket;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.inventory.PlayerInventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.protocol.data.game.ClientCommand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.level.notify.EnterCreditsValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.notify.RainStrengthValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.notify.RespawnScreenValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.notify.ThunderStrengthValue;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundGameEventPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundClientCommandPacket;

@Translator(packet=ClientboundGameEventPacket.class)
public class JavaGameEventTranslator
extends PacketTranslator<ClientboundGameEventPacket> {
    private static final int MAX_STORM_STRENGTH = 65535;

    @Override
    public void translate(GeyserSession session, ClientboundGameEventPacket packet) {
        SessionPlayerEntity entity = session.getPlayerEntity();
        switch (packet.getNotification()) {
            case START_RAIN: {
                LevelEventPacket stopRainPacket = new LevelEventPacket();
                stopRainPacket.setType(LevelEvent.STOP_RAINING);
                stopRainPacket.setData(0);
                stopRainPacket.setPosition(Vector3f.ZERO);
                session.sendUpstreamPacket(stopRainPacket);
                session.setRaining(false);
                break;
            }
            case STOP_RAIN: {
                LevelEventPacket startRainPacket = new LevelEventPacket();
                startRainPacket.setType(LevelEvent.START_RAINING);
                startRainPacket.setData(65535);
                startRainPacket.setPosition(Vector3f.ZERO);
                session.sendUpstreamPacket(startRainPacket);
                session.setRaining(true);
                break;
            }
            case RAIN_STRENGTH: {
                float rainStrength = ((RainStrengthValue)packet.getValue()).getStrength();
                boolean isCurrentlyRaining = rainStrength > 0.0f;
                LevelEventPacket changeRainPacket = new LevelEventPacket();
                changeRainPacket.setType(isCurrentlyRaining ? LevelEvent.START_RAINING : LevelEvent.STOP_RAINING);
                changeRainPacket.setData((int)(rainStrength * 65535.0f));
                changeRainPacket.setPosition(Vector3f.ZERO);
                session.sendUpstreamPacket(changeRainPacket);
                session.setRaining(isCurrentlyRaining);
                break;
            }
            case THUNDER_STRENGTH: {
                float thunderStrength = ((ThunderStrengthValue)packet.getValue()).getStrength();
                boolean isCurrentlyThundering = thunderStrength > 0.0f;
                LevelEventPacket changeThunderPacket = new LevelEventPacket();
                changeThunderPacket.setType(isCurrentlyThundering ? LevelEvent.START_THUNDERSTORM : LevelEvent.STOP_THUNDERSTORM);
                changeThunderPacket.setData((int)(thunderStrength * 65535.0f));
                changeThunderPacket.setPosition(Vector3f.ZERO);
                session.sendUpstreamPacket(changeThunderPacket);
                session.setThunder(isCurrentlyThundering);
                break;
            }
            case CHANGE_GAMEMODE: {
                GameMode gameMode = (GameMode)packet.getValue();
                SetPlayerGameTypePacket playerGameTypePacket = new SetPlayerGameTypePacket();
                playerGameTypePacket.setGamemode(EntityUtils.toBedrockGamemode(gameMode).ordinal());
                session.sendUpstreamPacket(playerGameTypePacket);
                session.setGameMode(gameMode);
                session.sendAdventureSettings();
                if (session.getPlayerEntity().isOnGround() && gameMode == GameMode.SPECTATOR) {
                    MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
                    movePlayerPacket.setRuntimeEntityId(entity.getGeyserId());
                    movePlayerPacket.setPosition(entity.getPosition());
                    movePlayerPacket.setRotation(entity.getBedrockRotation());
                    movePlayerPacket.setOnGround(false);
                    movePlayerPacket.setMode(MovePlayerPacket.Mode.TELEPORT);
                    movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.UNKNOWN);
                    session.sendUpstreamPacket(movePlayerPacket);
                }
                PlayerInventoryTranslator.updateCraftingGrid(session, session.getPlayerInventory());
                break;
            }
            case ENTER_CREDITS: {
                switch ((EnterCreditsValue)packet.getValue()) {
                    case SEEN_BEFORE: {
                        ServerboundClientCommandPacket javaRespawnPacket = new ServerboundClientCommandPacket(ClientCommand.RESPAWN);
                        session.sendDownstreamGamePacket(javaRespawnPacket);
                        break;
                    }
                    case FIRST_TIME: {
                        ShowCreditsPacket showCreditsPacket = new ShowCreditsPacket();
                        showCreditsPacket.setStatus(ShowCreditsPacket.Status.START_CREDITS);
                        showCreditsPacket.setRuntimeEntityId(entity.getGeyserId());
                        session.sendUpstreamPacket(showCreditsPacket);
                    }
                }
                break;
            }
            case AFFECTED_BY_ELDER_GUARDIAN: {
                EntityEventPacket eventPacket = new EntityEventPacket();
                eventPacket.setType(EntityEventType.ELDER_GUARDIAN_CURSE);
                eventPacket.setData(0);
                eventPacket.setRuntimeEntityId(entity.getGeyserId());
                session.sendUpstreamPacket(eventPacket);
                break;
            }
            case ENABLE_RESPAWN_SCREEN: {
                GameRulesChangedPacket gamerulePacket = new GameRulesChangedPacket();
                gamerulePacket.getGameRules().add(new GameRuleData<Boolean>("doimmediaterespawn", packet.getValue() == RespawnScreenValue.IMMEDIATE_RESPAWN));
                session.sendUpstreamPacket(gamerulePacket);
                break;
            }
            case INVALID_BED: {
                session.sendMessage(MinecraftLocale.getLocaleString("block.minecraft.spawn.not_valid", session.locale()));
                break;
            }
            case ARROW_HIT_PLAYER: {
                PlaySoundPacket arrowSoundPacket = new PlaySoundPacket();
                arrowSoundPacket.setSound("random.orb");
                arrowSoundPacket.setPitch(0.5f);
                arrowSoundPacket.setVolume(0.5f);
                arrowSoundPacket.setPosition(entity.getPosition());
                session.sendUpstreamPacket(arrowSoundPacket);
                break;
            }
        }
    }
}

