/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.util.Set;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.PlayerActionType;
import org.cloudburstmc.protocol.bedrock.packet.ChangeDimensionPacket;
import org.cloudburstmc.protocol.bedrock.packet.ChunkRadiusUpdatedPacket;
import org.cloudburstmc.protocol.bedrock.packet.MobEffectPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerActionPacket;
import org.cloudburstmc.protocol.bedrock.packet.StopSoundPacket;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.ChunkCache;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public class DimensionUtils {
    private static int BEDROCK_NETHER_ID = 1;
    public static final String BEDROCK_FOG_HELL = "minecraft:fog_hell";
    public static final int OVERWORLD = 0;
    public static final int NETHER = 3;
    public static final int THE_END = 2;

    public static void switchDimension(GeyserSession session, int javaDimension) {
        int bedrockDimension = DimensionUtils.javaToBedrock(javaDimension);
        int previousDimension = session.getDimension();
        SessionPlayerEntity player = session.getPlayerEntity();
        session.getChunkCache().clear();
        session.getEntityCache().removeAllEntities();
        session.getItemFrameCache().clear();
        if (session.getLecternCache() != null) {
            session.getLecternCache().clear();
        }
        session.getLodestoneCache().clear();
        session.getPistonCache().clear();
        session.getSkullCache().clear();
        if (session.getServerRenderDistance() > 32 && !session.isEmulatePost1_13Logic()) {
            session.getGeyser().getLogger().debug("Applying dimension switching workaround for Bedrock render distance of " + session.getServerRenderDistance());
            ChunkRadiusUpdatedPacket chunkRadiusUpdatedPacket = new ChunkRadiusUpdatedPacket();
            chunkRadiusUpdatedPacket.setRadius(32);
            session.sendUpstreamPacket(chunkRadiusUpdatedPacket);
        }
        Vector3f pos = Vector3f.from(0.0f, 32767.0f, 0.0f);
        ChangeDimensionPacket changeDimensionPacket = new ChangeDimensionPacket();
        changeDimensionPacket.setDimension(bedrockDimension);
        changeDimensionPacket.setRespawn(true);
        changeDimensionPacket.setPosition(pos);
        session.sendUpstreamPacket(changeDimensionPacket);
        session.setDimension(javaDimension);
        DimensionUtils.setBedrockDimension(session, javaDimension);
        ((Entity)player).setPosition(pos);
        session.setSpawned(false);
        session.setLastChunkPosition(null);
        Set<Effect> entityEffects = session.getEffectCache().getEntityEffects();
        for (Effect effect : entityEffects) {
            MobEffectPacket mobEffectPacket = new MobEffectPacket();
            mobEffectPacket.setEvent(MobEffectPacket.Event.REMOVE);
            mobEffectPacket.setRuntimeEntityId(player.getGeyserId());
            mobEffectPacket.setEffectId(EntityUtils.toBedrockEffectId(effect));
            session.sendUpstreamPacket(mobEffectPacket);
        }
        entityEffects.clear();
        StopSoundPacket stopSoundPacket = new StopSoundPacket();
        stopSoundPacket.setStoppingAllSound(true);
        stopSoundPacket.setSoundName("");
        session.sendUpstreamPacket(stopSoundPacket);
        PlayerActionPacket ackPacket = new PlayerActionPacket();
        ackPacket.setRuntimeEntityId(player.getGeyserId());
        ackPacket.setAction(PlayerActionType.DIMENSION_CHANGE_SUCCESS);
        ackPacket.setBlockPosition(Vector3i.ZERO);
        ackPacket.setResultPosition(Vector3i.ZERO);
        ackPacket.setFace(0);
        session.sendUpstreamPacket(ackPacket);
        ChunkUtils.sendEmptyChunks(session, player.getPosition().toInt(), 3, true);
        if (DimensionUtils.isCustomBedrockNetherId()) {
            if (3 == javaDimension) {
                session.camera().sendFog(BEDROCK_FOG_HELL);
            } else if (3 == previousDimension) {
                session.camera().removeFog(BEDROCK_FOG_HELL);
            }
        }
    }

    public static void setBedrockDimension(GeyserSession session, int javaDimension) {
        ChunkCache chunkCache = session.getChunkCache();
        chunkCache.setBedrockDimension(switch (javaDimension) {
            case 2 -> BedrockDimension.THE_END;
            case 3 -> {
                if (DimensionUtils.isCustomBedrockNetherId()) {
                    yield BedrockDimension.THE_END;
                }
                yield BedrockDimension.THE_NETHER;
            }
            default -> BedrockDimension.OVERWORLD;
        });
    }

    public static int javaToBedrock(BedrockDimension dimension) {
        if (dimension == BedrockDimension.THE_NETHER) {
            return BEDROCK_NETHER_ID;
        }
        if (dimension == BedrockDimension.THE_END) {
            return 2;
        }
        return 0;
    }

    public static int javaToBedrock(int javaDimension) {
        return switch (javaDimension) {
            case 3 -> BEDROCK_NETHER_ID;
            case 2 -> 2;
            default -> 0;
        };
    }

    public static int javaToBedrock(String javaDimension) {
        return switch (javaDimension) {
            case "minecraft:the_nether" -> BEDROCK_NETHER_ID;
            case "minecraft:the_end" -> 2;
            default -> 0;
        };
    }

    public static void changeBedrockNetherId(boolean isAboveNetherBedrockBuilding) {
        BEDROCK_NETHER_ID = isAboveNetherBedrockBuilding ? 2 : 1;
    }

    public static int getTemporaryDimension(int currentDimension, int newDimension) {
        if (DimensionUtils.isCustomBedrockNetherId()) {
            return DimensionUtils.javaToBedrock(newDimension) == 2 ? 0 : 3;
        }
        return DimensionUtils.javaToBedrock(currentDimension) == 0 ? 3 : 0;
    }

    public static boolean isCustomBedrockNetherId() {
        return BEDROCK_NETHER_ID == 2;
    }
}

