/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerHotbarPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.LecternContainer;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.click.Click;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapedRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapelessRecipe;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.inventory.LecternInventoryTranslator;
import org.geysermc.geyser.translator.inventory.chest.DoubleChestInventoryTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.Ingredient;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundPickItemPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundSetCreativeModeSlotPacket;
import org.jetbrains.annotations.Contract;

public class InventoryUtils {
    public static int LAST_RECIPE_NET_ID;
    public static final ItemStack REFRESH_ITEM;

    public static void openInventory(GeyserSession session, Inventory inventory) {
        session.setOpenInventory(inventory);
        if (session.isClosingInventory() || !session.getUpstream().isInitialized()) {
            inventory.setPending(true);
            return;
        }
        InventoryUtils.displayInventory(session, inventory);
    }

    public static void displayInventory(GeyserSession session, Inventory inventory) {
        InventoryTranslator translator = session.getInventoryTranslator();
        if (translator != null && translator.prepareInventory(session, inventory)) {
            if (translator instanceof DoubleChestInventoryTranslator && !((Container)inventory).isUsingRealBlock()) {
                session.scheduleInEventLoop(() -> {
                    Inventory openInv = session.getOpenInventory();
                    if (openInv != null && openInv.getJavaId() == inventory.getJavaId()) {
                        translator.openInventory(session, inventory);
                        translator.updateInventory(session, inventory);
                        openInv.setDisplayed(true);
                    } else if (openInv != null && openInv.isPending()) {
                        InventoryUtils.displayInventory(session, openInv);
                    }
                }, 200L, TimeUnit.MILLISECONDS);
            } else {
                translator.openInventory(session, inventory);
                translator.updateInventory(session, inventory);
                inventory.setDisplayed(true);
            }
        } else {
            session.setOpenInventory(null);
        }
    }

    public static void closeInventory(GeyserSession session, int javaId, boolean confirm) {
        session.getPlayerInventory().setCursor(GeyserItemStack.EMPTY, session);
        InventoryUtils.updateCursor(session);
        Inventory inventory = InventoryUtils.getInventory(session, javaId);
        if (inventory != null) {
            InventoryTranslator translator = session.getInventoryTranslator();
            translator.closeInventory(session, inventory);
            if (confirm && inventory.isDisplayed() && !inventory.isPending() && !(translator instanceof LecternInventoryTranslator)) {
                session.setClosingInventory(true);
            }
        }
        session.setInventoryTranslator(InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR);
        session.setOpenInventory(null);
    }

    public static @Nullable Inventory getInventory(GeyserSession session, int javaId) {
        if (javaId == 0) {
            if (session.getOpenInventory() instanceof LecternContainer) {
                return session.getOpenInventory();
            }
            return session.getPlayerInventory();
        }
        Inventory openInventory = session.getOpenInventory();
        if (openInventory != null && javaId == openInventory.getJavaId()) {
            return openInventory;
        }
        return null;
    }

    public static @Nullable Vector3i findAvailableWorldSpace(GeyserSession session) {
        BedrockDimension dimension = session.getChunkCache().getBedrockDimension();
        int minY = dimension.minY();
        int maxY = minY + dimension.height();
        Vector3i flatPlayerPosition = session.getPlayerEntity().getPosition().toInt();
        Vector3i position = flatPlayerPosition.add(Vector3i.UP);
        if (position.getY() < minY) {
            return null;
        }
        if (position.getY() >= maxY && (position = flatPlayerPosition.sub(0, 4, 0)).getY() >= maxY) {
            return null;
        }
        return position;
    }

    public static void updateCursor(GeyserSession session) {
        InventorySlotPacket cursorPacket = new InventorySlotPacket();
        cursorPacket.setContainerId(124);
        cursorPacket.setSlot(0);
        cursorPacket.setItem(session.getPlayerInventory().getCursor().getItemData(session));
        session.sendUpstreamPacket(cursorPacket);
    }

    public static boolean canStack(GeyserItemStack item1, GeyserItemStack item2) {
        if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
            InventoryUtils.canStackDebug(item1, item2);
        }
        if (item1.isEmpty() || item2.isEmpty()) {
            return false;
        }
        return item1.getJavaId() == item2.getJavaId() && Objects.equals(item1.getComponents(), item2.getComponents());
    }

    private static void canStackDebug(GeyserItemStack item1, GeyserItemStack item2) {
        DataComponents components1 = item1.getComponents();
        DataComponents components2 = item2.getComponents();
        if (components1 != null && components2 != null && components1.hashCode() == components2.hashCode() && !components1.equals(components2)) {
            GeyserImpl.getInstance().getLogger().error("DEBUG: DataComponents hash collision");
            GeyserImpl.getInstance().getLogger().error("hash: " + components1.hashCode());
            GeyserImpl.getInstance().getLogger().error("components1: " + components1);
            GeyserImpl.getInstance().getLogger().error("components2: " + components2);
        }
    }

    @Contract(value="null -> true")
    public static boolean isEmpty(@Nullable ItemStack itemStack) {
        return itemStack == null || itemStack.getId() == Items.AIR_ID || itemStack.getAmount() <= 0;
    }

    public static IntFunction<ItemData> createUnusableSpaceBlock(String description) {
        NbtMapBuilder root = NbtMap.builder();
        NbtMapBuilder display = NbtMap.builder();
        display.putString("Name", "\u00a7r" + GeyserLocale.getLocaleStringLog("geyser.inventory.unusable_item.name"));
        display.putList("Lore", NbtType.STRING, Collections.singletonList("\u00a7r\u00a75" + description));
        root.put("display", (Object)display.build());
        return protocolVersion -> ItemData.builder().definition(InventoryUtils.getUnusableSpaceBlockDefinition(protocolVersion)).count(1).tag(root.build()).build();
    }

    private static ItemDefinition getUnusableSpaceBlockDefinition(int protocolVersion) {
        String unusableSpaceBlock;
        ItemMappings mappings = Registries.ITEMS.forVersion(protocolVersion);
        ItemDefinition itemDefinition = mappings.getDefinition(unusableSpaceBlock = GeyserImpl.getInstance().getConfig().getUnusableSpaceBlock());
        if (itemDefinition == null) {
            GeyserImpl.getInstance().getLogger().error("Invalid value " + unusableSpaceBlock + ". Resorting to barrier block.");
            return mappings.getStoredItems().barrier().getBedrockDefinition();
        }
        return itemDefinition;
    }

    public static IntFunction<ItemData> getUpgradeTemplate() {
        return protocolVersion -> ItemData.builder().definition(Registries.ITEMS.forVersion(protocolVersion).getStoredItems().upgradeTemplate().getBedrockDefinition()).count(1).build();
    }

    public static void findOrCreateItem(GeyserSession session, ItemStack itemStack) {
        GeyserItemStack geyserItem;
        int i;
        if (InventoryUtils.isEmpty(itemStack)) {
            return;
        }
        PlayerInventory inventory = session.getPlayerInventory();
        for (i = 36; i < 45; ++i) {
            geyserItem = inventory.getItem(i);
            if (geyserItem.isEmpty() || geyserItem.getJavaId() != itemStack.getId() || !Objects.equals(geyserItem.getComponents(), itemStack.getDataComponents())) continue;
            InventoryUtils.setHotbarItem(session, i);
            return;
        }
        for (i = 9; i < 36; ++i) {
            geyserItem = inventory.getItem(i);
            if (geyserItem.isEmpty() || geyserItem.getJavaId() != itemStack.getId() || !Objects.equals(geyserItem.getComponents(), itemStack.getDataComponents())) continue;
            ServerboundPickItemPacket packetToSend = new ServerboundPickItemPacket(i);
            session.sendDownstreamGamePacket(packetToSend);
            return;
        }
        if (session.getGameMode() == GameMode.CREATIVE) {
            int slot = InventoryUtils.findEmptyHotbarSlot(inventory);
            ServerboundSetCreativeModeSlotPacket actionPacket = new ServerboundSetCreativeModeSlotPacket((short)slot, itemStack);
            if (slot - 36 != inventory.getHeldItemSlot()) {
                InventoryUtils.setHotbarItem(session, slot);
            }
            session.sendDownstreamGamePacket(actionPacket);
        }
    }

    public static void findOrCreateItem(GeyserSession session, String itemName) {
        GeyserItemStack geyserItem;
        int i;
        PlayerInventory inventory = session.getPlayerInventory();
        if (itemName.equals("minecraft:air")) {
            return;
        }
        for (i = 36; i < 45; ++i) {
            geyserItem = inventory.getItem(i);
            if (geyserItem.isEmpty() || !geyserItem.asItem().javaIdentifier().equals(itemName)) continue;
            InventoryUtils.setHotbarItem(session, i);
            return;
        }
        for (i = 9; i < 36; ++i) {
            geyserItem = inventory.getItem(i);
            if (geyserItem.isEmpty() || !geyserItem.asItem().javaIdentifier().equals(itemName)) continue;
            ServerboundPickItemPacket packetToSend = new ServerboundPickItemPacket(i);
            session.sendDownstreamGamePacket(packetToSend);
            return;
        }
        if (session.getGameMode() == GameMode.CREATIVE) {
            int slot = InventoryUtils.findEmptyHotbarSlot(inventory);
            ItemMapping mapping = session.getItemMappings().getMapping(itemName);
            if (mapping != null) {
                ServerboundSetCreativeModeSlotPacket actionPacket = new ServerboundSetCreativeModeSlotPacket((short)slot, new ItemStack(mapping.getJavaItem().javaId()));
                if (slot - 36 != inventory.getHeldItemSlot()) {
                    InventoryUtils.setHotbarItem(session, slot);
                }
                session.sendDownstreamGamePacket(actionPacket);
            } else {
                session.getGeyser().getLogger().debug("Cannot find item for block " + itemName);
            }
        }
    }

    private static int findEmptyHotbarSlot(PlayerInventory inventory) {
        int slot = inventory.getHeldItemSlot() + 36;
        if (!inventory.getItemInHand().isEmpty()) {
            for (int i = 36; i < 45; ++i) {
                if (!inventory.getItem(i).isEmpty()) continue;
                slot = i;
                break;
            }
        }
        return slot;
    }

    private static void setHotbarItem(GeyserSession session, int slot) {
        PlayerHotbarPacket hotbarPacket = new PlayerHotbarPacket();
        hotbarPacket.setContainerId(0);
        hotbarPacket.setSelectedHotbarSlot(slot - 36);
        hotbarPacket.setSelectHotbarSlot(true);
        session.sendUpstreamPacket(hotbarPacket);
    }

    public static @Nullable Click getClickForHotbarSwap(int slot) {
        return switch (slot) {
            case 0 -> Click.SWAP_TO_HOTBAR_1;
            case 1 -> Click.SWAP_TO_HOTBAR_2;
            case 2 -> Click.SWAP_TO_HOTBAR_3;
            case 3 -> Click.SWAP_TO_HOTBAR_4;
            case 4 -> Click.SWAP_TO_HOTBAR_5;
            case 5 -> Click.SWAP_TO_HOTBAR_6;
            case 6 -> Click.SWAP_TO_HOTBAR_7;
            case 7 -> Click.SWAP_TO_HOTBAR_8;
            case 8 -> Click.SWAP_TO_HOTBAR_9;
            default -> null;
        };
    }

    public static @Nullable GeyserRecipe getValidRecipe(GeyserSession session, @Nullable ItemStack output, IntFunction<GeyserItemStack> inventoryGetter, int gridDimensions, int firstRow, int height, int firstCol, int width) {
        int nonAirCount = 0;
        for (int row = firstRow; row < height + firstRow; ++row) {
            for (int col = firstCol; col < width + firstCol; ++col) {
                if (inventoryGetter.apply(col + row * gridDimensions + 1).isEmpty()) continue;
                ++nonAirCount;
            }
        }
        block2: for (GeyserRecipe recipe : session.getCraftingRecipes().values()) {
            if (recipe.isShaped()) {
                GeyserShapedRecipe shapedRecipe = (GeyserShapedRecipe)recipe;
                if (output != null && !shapedRecipe.result().equals(output)) continue;
                Object[] ingredients = shapedRecipe.ingredients();
                if (shapedRecipe.width() != width || shapedRecipe.height() != height || width * height != ingredients.length) continue;
                if (!InventoryUtils.testShapedRecipe((Ingredient[])ingredients, inventoryGetter, gridDimensions, firstRow, height, firstCol, width)) {
                    Object[] mirroredIngredients = new Ingredient[ingredients.length];
                    for (int row = 0; row < height; ++row) {
                        for (int col = 0; col < width; ++col) {
                            mirroredIngredients[col + row * width] = ingredients[width - 1 - col + row * width];
                        }
                    }
                    if (Arrays.equals(ingredients, mirroredIngredients) || !InventoryUtils.testShapedRecipe((Ingredient[])mirroredIngredients, inventoryGetter, gridDimensions, firstRow, height, firstCol, width)) {
                        continue;
                    }
                }
            } else {
                GeyserShapelessRecipe data = (GeyserShapelessRecipe)recipe;
                if (output != null && !data.result().equals(output) || nonAirCount != data.ingredients().length) continue;
                for (int i = 0; i < data.ingredients().length; ++i) {
                    Ingredient ingredient = data.ingredients()[i];
                    for (ItemStack itemStack : ingredient.getOptions()) {
                        boolean inventoryHasItem = false;
                        block7: for (int row = firstRow; row < height + firstRow; ++row) {
                            for (int col = firstCol; col < width + firstCol; ++col) {
                                GeyserItemStack geyserItemStack = inventoryGetter.apply(col + row * gridDimensions + 1);
                                if (geyserItemStack.isEmpty()) {
                                    boolean bl = inventoryHasItem = itemStack == null || itemStack.getId() == 0;
                                    if (!inventoryHasItem) continue;
                                    break block7;
                                }
                                if (!itemStack.equals(geyserItemStack.getItemStack(1))) continue;
                                inventoryHasItem = true;
                                break block7;
                            }
                        }
                        if (!inventoryHasItem) continue block2;
                    }
                }
            }
            return recipe;
        }
        return null;
    }

    private static boolean testShapedRecipe(Ingredient[] ingredients, IntFunction<GeyserItemStack> inventoryGetter, int gridDimensions, int firstRow, int height, int firstCol, int width) {
        int ingredientIndex = 0;
        for (int row = firstRow; row < height + firstRow; ++row) {
            for (int col = firstCol; col < width + firstCol; ++col) {
                Ingredient ingredient;
                GeyserItemStack geyserItemStack = inventoryGetter.apply(col + row * gridDimensions + 1);
                if ((ingredient = ingredients[ingredientIndex++]).getOptions().length == 0) {
                    if (geyserItemStack.isEmpty()) continue;
                    return false;
                }
                boolean inventoryHasItem = false;
                for (ItemStack item : ingredient.getOptions()) {
                    if (!Objects.equals(geyserItemStack.getItemStack(1), item)) continue;
                    inventoryHasItem = true;
                    break;
                }
                if (inventoryHasItem) continue;
                return false;
            }
        }
        return true;
    }

    static {
        REFRESH_ITEM = new ItemStack(1, 127, new DataComponents(new HashMap()));
    }
}

