/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.inventory.item.Enchantment;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.FishingRodItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;

public class ItemUtils {
    public static int getEnchantmentLevel(@Nullable DataComponents components, Enchantment.JavaEnchantment enchantment) {
        if (components == null) {
            return 0;
        }
        ItemEnchantments enchantmentData = components.get(DataComponentType.ENCHANTMENTS);
        if (enchantmentData == null) {
            return 0;
        }
        return enchantmentData.getEnchantments().getOrDefault(enchantment.ordinal(), 0);
    }

    public static int getCorrectBedrockDurability(Item item, int original) {
        if (item == Items.FISHING_ROD) {
            return FishingRodItem.getBedrockDamage(original);
        }
        return original;
    }

    public static @Nullable Component getCustomName(DataComponents components) {
        if (components == null) {
            return null;
        }
        return components.get(DataComponentType.CUSTOM_NAME);
    }
}

