/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util.collection;

import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.AbstractInt2BooleanMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectSet;

public class FixedInt2BooleanMap
extends AbstractInt2BooleanMap {
    private static final long serialVersionUID = 1L;
    protected boolean[] value;
    protected int start = -1;

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public ObjectSet<Int2BooleanMap.Entry> int2BooleanEntrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean get(int i) {
        return this.getOrDefault(i, this.defRetValue);
    }

    @Override
    public boolean getOrDefault(int key, boolean defaultValue) {
        int offset = key - this.start;
        if (offset < 0 || offset >= this.value.length) {
            return defaultValue;
        }
        return this.value[offset];
    }

    @Override
    public boolean put(int key, boolean value) {
        if (this.start == -1) {
            this.start = key;
            this.value = new boolean[]{value};
        } else {
            int offset = key - this.start;
            if (offset >= 0 && offset < this.value.length) {
                boolean curr = this.value[offset];
                this.value[offset] = value;
                return curr;
            }
            if (offset != this.value.length) {
                throw new IndexOutOfBoundsException("Expected: " + (this.value.length + this.start) + ", got " + key);
            }
            boolean[] newValue = new boolean[offset + 1];
            System.arraycopy(this.value, 0, newValue, 0, this.value.length);
            this.value = newValue;
            this.value[offset] = value;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(int k) {
        int offset = k - this.start;
        return offset >= 0 && offset < this.value.length;
    }

    @Override
    public boolean containsValue(boolean v) {
        for (boolean b : this.value) {
            if (b != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        int index = this.start;
        for (boolean b : this.value) {
            builder.append(index++).append("=>").append(b);
            if (index >= this.value.length + this.start) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }
}

