/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util.collection;

import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.AbstractInt2ByteMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ByteMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectSet;

public class FixedInt2ByteMap
extends AbstractInt2ByteMap {
    private static final long serialVersionUID = 1L;
    protected byte[] value;
    protected int start = -1;

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public ObjectSet<Int2ByteMap.Entry> int2ByteEntrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte get(int i) {
        return this.getOrDefault(i, this.defRetValue);
    }

    @Override
    public byte getOrDefault(int key, byte defaultValue) {
        int offset = key - this.start;
        if (offset < 0 || offset >= this.value.length) {
            return defaultValue;
        }
        return this.value[offset];
    }

    @Override
    public byte put(int key, byte value) {
        if (this.start == -1) {
            this.start = key;
            this.value = new byte[]{value};
        } else {
            int offset = key - this.start;
            if (offset >= 0 && offset < this.value.length) {
                byte curr = this.value[offset];
                this.value[offset] = value;
                return curr;
            }
            if (offset != this.value.length) {
                throw new IndexOutOfBoundsException("Expected: " + (this.value.length + this.start) + ", got " + key);
            }
            byte[] newValue = new byte[offset + 1];
            System.arraycopy(this.value, 0, newValue, 0, this.value.length);
            this.value = newValue;
            this.value[offset] = value;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(int k) {
        int offset = k - this.start;
        return offset >= 0 && offset < this.value.length;
    }

    @Override
    public boolean containsValue(byte v) {
        for (byte i : this.value) {
            if (i != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        int index = this.start;
        for (byte b : this.value) {
            builder.append(index++).append("=>").append(b);
            if (index >= this.value.length + this.start) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }
}

