/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.function.Supplier;
import org.geysermc.mcprotocollib.network.AbstractServer;
import org.geysermc.mcprotocollib.network.BuiltinFlags;
import org.geysermc.mcprotocollib.network.helper.TransportHelper;
import org.geysermc.mcprotocollib.network.packet.PacketProtocol;
import org.geysermc.mcprotocollib.network.tcp.TcpPacketCodec;
import org.geysermc.mcprotocollib.network.tcp.TcpPacketSizer;
import org.geysermc.mcprotocollib.network.tcp.TcpServerSession;

public class TcpServer
extends AbstractServer {
    private static final TransportHelper.TransportType TRANSPORT_TYPE = TransportHelper.determineTransportMethod();
    private EventLoopGroup group;
    private Channel channel;

    public TcpServer(String host, int port, Supplier<? extends PacketProtocol> protocol) {
        super(host, port, protocol);
    }

    @Override
    public boolean isListening() {
        return this.channel != null && this.channel.isOpen();
    }

    @Override
    public void bindImpl(boolean wait, Runnable callback) {
        if (this.group != null || this.channel != null) {
            return;
        }
        this.group = TRANSPORT_TYPE.eventLoopGroupFactory().apply(null);
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channelFactory(TRANSPORT_TYPE.serverSocketChannelFactory())).group(this.group).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.IP_TOS, (Object)24).localAddress(this.getHost(), this.getPort())).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel channel) {
                InetSocketAddress address = (InetSocketAddress)channel.remoteAddress();
                PacketProtocol protocol = TcpServer.this.createPacketProtocol();
                TcpServerSession session = new TcpServerSession(address.getHostName(), address.getPort(), protocol, TcpServer.this);
                session.getPacketProtocol().newServerSession(TcpServer.this, session);
                ChannelPipeline pipeline = channel.pipeline();
                session.refreshReadTimeoutHandler(channel);
                session.refreshWriteTimeoutHandler(channel);
                int size = protocol.getPacketHeader().getLengthSize();
                if (size > 0) {
                    pipeline.addLast("sizer", (ChannelHandler)new TcpPacketSizer(session, size));
                }
                pipeline.addLast("codec", (ChannelHandler)new TcpPacketCodec(session, false));
                pipeline.addLast("manager", (ChannelHandler)session);
            }
        });
        if (this.getGlobalFlag(BuiltinFlags.TCP_FAST_OPEN, false).booleanValue() && TRANSPORT_TYPE.supportsTcpFastOpenServer()) {
            bootstrap.option(ChannelOption.TCP_FASTOPEN, (Object)3);
        }
        ChannelFuture future = bootstrap.bind();
        if (wait) {
            try {
                future.sync();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.channel = future.channel();
            if (callback != null) {
                callback.run();
            }
        } else {
            future.addListener((GenericFutureListener)((ChannelFutureListener)future1 -> {
                if (future1.isSuccess()) {
                    this.channel = future1.channel();
                    if (callback != null) {
                        callback.run();
                    }
                } else {
                    System.err.println("[ERROR] Failed to asynchronously bind connection listener.");
                    if (future1.cause() != null) {
                        future1.cause().printStackTrace();
                    }
                }
            }));
        }
    }

    @Override
    public void closeImpl(boolean wait, Runnable callback) {
        Future future;
        if (this.channel != null) {
            if (this.channel.isOpen()) {
                future = this.channel.close();
                if (wait) {
                    try {
                        future.sync();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (callback != null) {
                        callback.run();
                    }
                } else {
                    future.addListener((GenericFutureListener)((ChannelFutureListener)future1 -> {
                        if (future1.isSuccess()) {
                            if (callback != null) {
                                callback.run();
                            }
                        } else {
                            System.err.println("[ERROR] Failed to asynchronously close connection listener.");
                            if (future1.cause() != null) {
                                future1.cause().printStackTrace();
                            }
                        }
                    }));
                }
            }
            this.channel = null;
        }
        if (this.group != null) {
            future = this.group.shutdownGracefully();
            if (wait) {
                try {
                    future.sync();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                future.addListener(future1 -> {
                    if (!future1.isSuccess() && this.getGlobalFlag(BuiltinFlags.PRINT_DEBUG, false).booleanValue()) {
                        System.err.println("[ERROR] Failed to asynchronously close connection listener.");
                        if (future1.cause() != null) {
                            future1.cause().printStackTrace();
                        }
                    }
                });
            }
            this.group = null;
        }
    }
}

