/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.chat;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.geysermc.mcprotocollib.protocol.data.game.Identifier;

public enum BuiltinChatType {
    CHAT,
    SAY_COMMAND,
    MSG_COMMAND_INCOMING,
    MSG_COMMAND_OUTGOING,
    TEAM_MSG_COMMAND_INCOMING,
    TEAM_MSG_COMMAND_OUTGOING,
    EMOTE_COMMAND;

    private final String resourceLocation = Identifier.formalize(this.name().toLowerCase(Locale.ROOT));
    private static final Map<String, BuiltinChatType> VALUES;

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public static BuiltinChatType from(String resourceLocation) {
        return VALUES.get(resourceLocation);
    }

    static {
        VALUES = new HashMap<String, BuiltinChatType>();
        for (BuiltinChatType type : BuiltinChatType.values()) {
            VALUES.put(type.getResourceLocation(), type);
        }
    }
}

