/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.chunk.palette;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2IntMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.Palette;

public class MapPalette
implements Palette {
    private static final int MISSING_ID = -1;
    private final int capacity;
    private final int[] idToState;
    private final Int2IntMap stateToId = new Int2IntOpenHashMap();
    private int nextId = 0;

    public MapPalette(int bitsPerEntry) {
        this.capacity = 1 << bitsPerEntry;
        this.idToState = new int[this.capacity];
        this.stateToId.defaultReturnValue(-1);
    }

    public MapPalette(int bitsPerEntry, ByteBuf in, MinecraftCodecHelper helper) {
        this(bitsPerEntry);
        int paletteLength = helper.readVarInt(in);
        for (int i = 0; i < paletteLength; ++i) {
            int state;
            this.idToState[i] = state = helper.readVarInt(in);
            this.stateToId.putIfAbsent(state, i);
        }
        this.nextId = paletteLength;
    }

    @Override
    public int size() {
        return this.nextId;
    }

    @Override
    public int stateToId(int state) {
        int id = this.stateToId.get(state);
        if (id == -1 && this.size() < this.capacity) {
            id = this.nextId++;
            this.idToState[id] = state;
            this.stateToId.put(state, id);
        }
        return id;
    }

    @Override
    public int idToState(int id) {
        if (id >= 0 && id < this.size()) {
            return this.idToState[id];
        }
        return 0;
    }

    @Override
    public MapPalette copy() {
        MapPalette mapPalette = new MapPalette(this.capacity, Arrays.copyOf(this.idToState, this.idToState.length), this.nextId);
        mapPalette.stateToId.putAll(this.stateToId);
        return mapPalette;
    }

    private MapPalette(int capacity, int[] idToState, int nextId) {
        this.capacity = capacity;
        this.idToState = idToState;
        this.nextId = nextId;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapPalette)) {
            return false;
        }
        MapPalette other = (MapPalette)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.capacity != other.capacity) {
            return false;
        }
        if (this.nextId != other.nextId) {
            return false;
        }
        if (!Arrays.equals(this.idToState, other.idToState)) {
            return false;
        }
        Int2IntMap this$stateToId = this.stateToId;
        Int2IntMap other$stateToId = other.stateToId;
        return !(this$stateToId == null ? other$stateToId != null : !this$stateToId.equals(other$stateToId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MapPalette;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.capacity;
        result = result * 59 + this.nextId;
        result = result * 59 + Arrays.hashCode(this.idToState);
        Int2IntMap $stateToId = this.stateToId;
        result = result * 59 + ($stateToId == null ? 43 : $stateToId.hashCode());
        return result;
    }
}

