/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.MobEffectDetails;

public class FoodProperties {
    private final int nutrition;
    private final float saturationModifier;
    private final boolean canAlwaysEat;
    private final float eatSeconds;
    private final List<PossibleEffect> effects;

    public int getNutrition() {
        return this.nutrition;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public boolean isCanAlwaysEat() {
        return this.canAlwaysEat;
    }

    public float getEatSeconds() {
        return this.eatSeconds;
    }

    public List<PossibleEffect> getEffects() {
        return this.effects;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FoodProperties)) {
            return false;
        }
        FoodProperties other = (FoodProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNutrition() != other.getNutrition()) {
            return false;
        }
        if (Float.compare(this.getSaturationModifier(), other.getSaturationModifier()) != 0) {
            return false;
        }
        if (this.isCanAlwaysEat() != other.isCanAlwaysEat()) {
            return false;
        }
        if (Float.compare(this.getEatSeconds(), other.getEatSeconds()) != 0) {
            return false;
        }
        List<PossibleEffect> this$effects = this.getEffects();
        List<PossibleEffect> other$effects = other.getEffects();
        return !(this$effects == null ? other$effects != null : !((Object)this$effects).equals(other$effects));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FoodProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNutrition();
        result = result * 59 + Float.floatToIntBits(this.getSaturationModifier());
        result = result * 59 + (this.isCanAlwaysEat() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getEatSeconds());
        List<PossibleEffect> $effects = this.getEffects();
        result = result * 59 + ($effects == null ? 43 : ((Object)$effects).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "FoodProperties(nutrition=" + this.getNutrition() + ", saturationModifier=" + this.getSaturationModifier() + ", canAlwaysEat=" + this.isCanAlwaysEat() + ", eatSeconds=" + this.getEatSeconds() + ", effects=" + this.getEffects() + ")";
    }

    public FoodProperties(int nutrition, float saturationModifier, boolean canAlwaysEat, float eatSeconds, List<PossibleEffect> effects) {
        this.nutrition = nutrition;
        this.saturationModifier = saturationModifier;
        this.canAlwaysEat = canAlwaysEat;
        this.eatSeconds = eatSeconds;
        this.effects = effects;
    }

    public static class PossibleEffect {
        private final MobEffectDetails effect;
        private final float probability;

        public MobEffectDetails getEffect() {
            return this.effect;
        }

        public float getProbability() {
            return this.probability;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PossibleEffect)) {
                return false;
            }
            PossibleEffect other = (PossibleEffect)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getProbability(), other.getProbability()) != 0) {
                return false;
            }
            MobEffectDetails this$effect = this.getEffect();
            MobEffectDetails other$effect = other.getEffect();
            return !(this$effect == null ? other$effect != null : !((Object)this$effect).equals(other$effect));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof PossibleEffect;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getProbability());
            MobEffectDetails $effect = this.getEffect();
            result = result * 59 + ($effect == null ? 43 : ((Object)$effect).hashCode());
            return result;
        }

        public @NonNull String toString() {
            return "FoodProperties.PossibleEffect(effect=" + this.getEffect() + ", probability=" + this.getProbability() + ")";
        }

        public PossibleEffect(MobEffectDetails effect, float probability) {
            this.effect = effect;
            this.probability = probability;
        }
    }
}

