/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundProjectilePowerPacket
implements MinecraftPacket {
    private final int id;
    private final double xPower;
    private final double yPower;
    private final double zPower;

    public ClientboundProjectilePowerPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.id = helper.readVarInt(in);
        this.xPower = in.readDouble();
        this.yPower = in.readDouble();
        this.zPower = in.readDouble();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.id);
        out.writeDouble(this.xPower);
        out.writeDouble(this.yPower);
        out.writeDouble(this.zPower);
    }

    public int getId() {
        return this.id;
    }

    public double getXPower() {
        return this.xPower;
    }

    public double getYPower() {
        return this.yPower;
    }

    public double getZPower() {
        return this.zPower;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundProjectilePowerPacket)) {
            return false;
        }
        ClientboundProjectilePowerPacket other = (ClientboundProjectilePowerPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (Double.compare(this.getXPower(), other.getXPower()) != 0) {
            return false;
        }
        if (Double.compare(this.getYPower(), other.getYPower()) != 0) {
            return false;
        }
        return Double.compare(this.getZPower(), other.getZPower()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundProjectilePowerPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        long $xPower = Double.doubleToLongBits(this.getXPower());
        result = result * 59 + (int)($xPower >>> 32 ^ $xPower);
        long $yPower = Double.doubleToLongBits(this.getYPower());
        result = result * 59 + (int)($yPower >>> 32 ^ $yPower);
        long $zPower = Double.doubleToLongBits(this.getZPower());
        result = result * 59 + (int)($zPower >>> 32 ^ $zPower);
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundProjectilePowerPacket(id=" + this.getId() + ", xPower=" + this.getXPower() + ", yPower=" + this.getYPower() + ", zPower=" + this.getZPower() + ")";
    }

    public @NonNull ClientboundProjectilePowerPacket withId(int id) {
        return this.id == id ? this : new ClientboundProjectilePowerPacket(id, this.xPower, this.yPower, this.zPower);
    }

    public @NonNull ClientboundProjectilePowerPacket withXPower(double xPower) {
        return this.xPower == xPower ? this : new ClientboundProjectilePowerPacket(this.id, xPower, this.yPower, this.zPower);
    }

    public @NonNull ClientboundProjectilePowerPacket withYPower(double yPower) {
        return this.yPower == yPower ? this : new ClientboundProjectilePowerPacket(this.id, this.xPower, yPower, this.zPower);
    }

    public @NonNull ClientboundProjectilePowerPacket withZPower(double zPower) {
        return this.zPower == zPower ? this : new ClientboundProjectilePowerPacket(this.id, this.xPower, this.yPower, zPower);
    }

    public ClientboundProjectilePowerPacket(int id, double xPower, double yPower, double zPower) {
        this.id = id;
        this.xPower = xPower;
        this.yPower = yPower;
        this.zPower = zPower;
    }
}

