/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.scoreboard;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.CollisionRule;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.NameTagVisibility;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.TeamAction;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.TeamColor;

public class ClientboundSetPlayerTeamPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final String teamName;
    @lombok.NonNull
    private final TeamAction action;
    private final Component displayName;
    private final Component prefix;
    private final Component suffix;
    private final boolean friendlyFire;
    private final boolean seeFriendlyInvisibles;
    private final @Nullable NameTagVisibility nameTagVisibility;
    private final @Nullable CollisionRule collisionRule;
    private final TeamColor color;
    private final String[] players;

    public ClientboundSetPlayerTeamPacket(@lombok.NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        this.teamName = teamName;
        this.action = TeamAction.REMOVE;
        this.displayName = null;
        this.prefix = null;
        this.suffix = null;
        this.friendlyFire = false;
        this.seeFriendlyInvisibles = false;
        this.nameTagVisibility = null;
        this.collisionRule = null;
        this.color = null;
        this.players = null;
    }

    public ClientboundSetPlayerTeamPacket(@lombok.NonNull String teamName, @lombok.NonNull Component displayName, @lombok.NonNull Component prefix, @lombok.NonNull Component suffix, boolean friendlyFire, boolean seeFriendlyInvisibles, @lombok.NonNull NameTagVisibility nameTagVisibility, @lombok.NonNull CollisionRule collisionRule, @lombok.NonNull TeamColor color) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (nameTagVisibility == null) {
            throw new NullPointerException("nameTagVisibility is marked non-null but is null");
        }
        if (collisionRule == null) {
            throw new NullPointerException("collisionRule is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        this.teamName = teamName;
        this.action = TeamAction.UPDATE;
        this.displayName = displayName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.friendlyFire = friendlyFire;
        this.seeFriendlyInvisibles = seeFriendlyInvisibles;
        this.nameTagVisibility = nameTagVisibility;
        this.collisionRule = collisionRule;
        this.color = color;
        this.players = null;
    }

    public ClientboundSetPlayerTeamPacket(@lombok.NonNull String teamName, @lombok.NonNull TeamAction action, @lombok.NonNull String[] players) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (players == null) {
            throw new NullPointerException("players is marked non-null but is null");
        }
        if (action != TeamAction.ADD_PLAYER && action != TeamAction.REMOVE_PLAYER) {
            throw new IllegalArgumentException("(name, action, players) constructor only valid for adding and removing players.");
        }
        this.teamName = teamName;
        this.action = action;
        this.displayName = null;
        this.prefix = null;
        this.suffix = null;
        this.friendlyFire = false;
        this.seeFriendlyInvisibles = false;
        this.nameTagVisibility = null;
        this.collisionRule = null;
        this.color = null;
        this.players = Arrays.copyOf(players, players.length);
    }

    public ClientboundSetPlayerTeamPacket(@lombok.NonNull String teamName, @lombok.NonNull Component displayName, @lombok.NonNull Component prefix, @lombok.NonNull Component suffix, boolean friendlyFire, boolean seeFriendlyInvisibles, @lombok.NonNull NameTagVisibility nameTagVisibility, @lombok.NonNull CollisionRule collisionRule, @lombok.NonNull TeamColor color, @lombok.NonNull String[] players) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (nameTagVisibility == null) {
            throw new NullPointerException("nameTagVisibility is marked non-null but is null");
        }
        if (collisionRule == null) {
            throw new NullPointerException("collisionRule is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (players == null) {
            throw new NullPointerException("players is marked non-null but is null");
        }
        this.teamName = teamName;
        this.action = TeamAction.CREATE;
        this.displayName = displayName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.friendlyFire = friendlyFire;
        this.seeFriendlyInvisibles = seeFriendlyInvisibles;
        this.nameTagVisibility = nameTagVisibility;
        this.collisionRule = collisionRule;
        this.color = color;
        this.players = Arrays.copyOf(players, players.length);
    }

    public ClientboundSetPlayerTeamPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.teamName = helper.readString(in);
        this.action = TeamAction.from(in.readByte());
        if (this.action == TeamAction.CREATE || this.action == TeamAction.UPDATE) {
            this.displayName = helper.readComponent(in);
            byte flags = in.readByte();
            this.friendlyFire = (flags & 1) != 0;
            this.seeFriendlyInvisibles = (flags & 2) != 0;
            this.nameTagVisibility = NameTagVisibility.from(helper.readString(in));
            this.collisionRule = CollisionRule.from(helper.readString(in));
            this.color = TeamColor.VALUES[helper.readVarInt(in)];
            this.prefix = helper.readComponent(in);
            this.suffix = helper.readComponent(in);
        } else {
            this.displayName = null;
            this.prefix = null;
            this.suffix = null;
            this.friendlyFire = false;
            this.seeFriendlyInvisibles = false;
            this.nameTagVisibility = null;
            this.collisionRule = null;
            this.color = null;
        }
        if (this.action == TeamAction.CREATE || this.action == TeamAction.ADD_PLAYER || this.action == TeamAction.REMOVE_PLAYER) {
            this.players = new String[helper.readVarInt(in)];
            for (int index = 0; index < this.players.length; ++index) {
                this.players[index] = helper.readString(in);
            }
        } else {
            this.players = null;
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeString(out, this.teamName);
        out.writeByte(this.action.ordinal());
        if (this.action == TeamAction.CREATE || this.action == TeamAction.UPDATE) {
            helper.writeComponent(out, this.displayName);
            out.writeByte((this.friendlyFire ? 1 : 0) | (this.seeFriendlyInvisibles ? 2 : 0));
            helper.writeString(out, this.nameTagVisibility == null ? "" : this.nameTagVisibility.getName());
            helper.writeString(out, this.collisionRule == null ? "" : this.collisionRule.getName());
            helper.writeVarInt(out, this.color.ordinal());
            helper.writeComponent(out, this.prefix);
            helper.writeComponent(out, this.suffix);
        }
        if (this.action == TeamAction.CREATE || this.action == TeamAction.ADD_PLAYER || this.action == TeamAction.REMOVE_PLAYER) {
            helper.writeVarInt(out, this.players.length);
            for (String player : this.players) {
                if (player == null) continue;
                helper.writeString(out, player);
            }
        }
    }

    @lombok.NonNull
    public String getTeamName() {
        return this.teamName;
    }

    @lombok.NonNull
    public TeamAction getAction() {
        return this.action;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public Component getPrefix() {
        return this.prefix;
    }

    public Component getSuffix() {
        return this.suffix;
    }

    public boolean isFriendlyFire() {
        return this.friendlyFire;
    }

    public boolean isSeeFriendlyInvisibles() {
        return this.seeFriendlyInvisibles;
    }

    public @Nullable NameTagVisibility getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    public @Nullable CollisionRule getCollisionRule() {
        return this.collisionRule;
    }

    public TeamColor getColor() {
        return this.color;
    }

    public String[] getPlayers() {
        return this.players;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetPlayerTeamPacket)) {
            return false;
        }
        ClientboundSetPlayerTeamPacket other = (ClientboundSetPlayerTeamPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFriendlyFire() != other.isFriendlyFire()) {
            return false;
        }
        if (this.isSeeFriendlyInvisibles() != other.isSeeFriendlyInvisibles()) {
            return false;
        }
        String this$teamName = this.getTeamName();
        String other$teamName = other.getTeamName();
        if (this$teamName == null ? other$teamName != null : !this$teamName.equals(other$teamName)) {
            return false;
        }
        TeamAction this$action = this.getAction();
        TeamAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Component this$displayName = this.getDisplayName();
        Component other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Component this$prefix = this.getPrefix();
        Component other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        Component this$suffix = this.getSuffix();
        Component other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        NameTagVisibility this$nameTagVisibility = this.getNameTagVisibility();
        NameTagVisibility other$nameTagVisibility = other.getNameTagVisibility();
        if (this$nameTagVisibility == null ? other$nameTagVisibility != null : !((Object)((Object)this$nameTagVisibility)).equals((Object)other$nameTagVisibility)) {
            return false;
        }
        CollisionRule this$collisionRule = this.getCollisionRule();
        CollisionRule other$collisionRule = other.getCollisionRule();
        if (this$collisionRule == null ? other$collisionRule != null : !((Object)((Object)this$collisionRule)).equals((Object)other$collisionRule)) {
            return false;
        }
        TeamColor this$color = this.getColor();
        TeamColor other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)((Object)this$color)).equals((Object)other$color)) {
            return false;
        }
        return Arrays.deepEquals(this.getPlayers(), other.getPlayers());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetPlayerTeamPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFriendlyFire() ? 79 : 97);
        result = result * 59 + (this.isSeeFriendlyInvisibles() ? 79 : 97);
        String $teamName = this.getTeamName();
        result = result * 59 + ($teamName == null ? 43 : $teamName.hashCode());
        TeamAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Component $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Component $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        Component $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        NameTagVisibility $nameTagVisibility = this.getNameTagVisibility();
        result = result * 59 + ($nameTagVisibility == null ? 43 : ((Object)((Object)$nameTagVisibility)).hashCode());
        CollisionRule $collisionRule = this.getCollisionRule();
        result = result * 59 + ($collisionRule == null ? 43 : ((Object)((Object)$collisionRule)).hashCode());
        TeamColor $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)((Object)$color)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPlayers());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetPlayerTeamPacket(teamName=" + this.getTeamName() + ", action=" + this.getAction() + ", displayName=" + this.getDisplayName() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", friendlyFire=" + this.isFriendlyFire() + ", seeFriendlyInvisibles=" + this.isSeeFriendlyInvisibles() + ", nameTagVisibility=" + this.getNameTagVisibility() + ", collisionRule=" + this.getCollisionRule() + ", color=" + this.getColor() + ", players=" + Arrays.deepToString(this.getPlayers()) + ")";
    }

    public @NonNull ClientboundSetPlayerTeamPacket withTeamName(@lombok.NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        return this.teamName == teamName ? this : new ClientboundSetPlayerTeamPacket(teamName, this.action, this.displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public @NonNull ClientboundSetPlayerTeamPacket withAction(@lombok.NonNull TeamAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ClientboundSetPlayerTeamPacket(this.teamName, action, this.displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public @NonNull ClientboundSetPlayerTeamPacket withDisplayName(Component displayName) {
        return this.displayName == displayName ? this : new ClientboundSetPlayerTeamPacket(this.teamName, this.action, displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public @NonNull ClientboundSetPlayerTeamPacket withPrefix(Component prefix) {
        return this.prefix == prefix ? this : new ClientboundSetPlayerTeamPacket(this.teamName, this.action, this.displayName, prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public @NonNull ClientboundSetPlayerTeamPacket withSuffix(Component suffix) {
        return this.suffix == suffix ? this : new ClientboundSetPlayerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public @NonNull ClientboundSetPlayerTeamPacket withFriendlyFire(boolean friendlyFire) {
        return this.friendlyFire == friendlyFire ? this : new ClientboundSetPlayerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, this.suffix, friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public @NonNull ClientboundSetPlayerTeamPacket withSeeFriendlyInvisibles(boolean seeFriendlyInvisibles) {
        return this.seeFriendlyInvisibles == seeFriendlyInvisibles ? this : new ClientboundSetPlayerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, this.suffix, this.friendlyFire, seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public @NonNull ClientboundSetPlayerTeamPacket withNameTagVisibility(@Nullable NameTagVisibility nameTagVisibility) {
        return this.nameTagVisibility == nameTagVisibility ? this : new ClientboundSetPlayerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public @NonNull ClientboundSetPlayerTeamPacket withCollisionRule(@Nullable CollisionRule collisionRule) {
        return this.collisionRule == collisionRule ? this : new ClientboundSetPlayerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, collisionRule, this.color, this.players);
    }

    public @NonNull ClientboundSetPlayerTeamPacket withColor(TeamColor color) {
        return this.color == color ? this : new ClientboundSetPlayerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, color, this.players);
    }

    public @NonNull ClientboundSetPlayerTeamPacket withPlayers(String[] players) {
        return this.players == players ? this : new ClientboundSetPlayerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, players);
    }

    private ClientboundSetPlayerTeamPacket(@lombok.NonNull String teamName, @lombok.NonNull TeamAction action, Component displayName, Component prefix, Component suffix, boolean friendlyFire, boolean seeFriendlyInvisibles, @Nullable NameTagVisibility nameTagVisibility, @Nullable CollisionRule collisionRule, TeamColor color, String[] players) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.teamName = teamName;
        this.action = action;
        this.displayName = displayName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.friendlyFire = friendlyFire;
        this.seeFriendlyInvisibles = seeFriendlyInvisibles;
        this.nameTagVisibility = nameTagVisibility;
        this.collisionRule = collisionRule;
        this.color = color;
        this.players = players;
    }
}

