/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundJigsawGeneratePacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Vector3i position;
    private final int levels;
    private final boolean keepJigsaws;

    public ServerboundJigsawGeneratePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.position = helper.readPosition(in);
        this.levels = helper.readVarInt(in);
        this.keepJigsaws = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writePosition(out, this.position);
        helper.writeVarInt(out, this.levels);
        out.writeBoolean(this.keepJigsaws);
    }

    @lombok.NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    public int getLevels() {
        return this.levels;
    }

    public boolean isKeepJigsaws() {
        return this.keepJigsaws;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundJigsawGeneratePacket)) {
            return false;
        }
        ServerboundJigsawGeneratePacket other = (ServerboundJigsawGeneratePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevels() != other.getLevels()) {
            return false;
        }
        if (this.isKeepJigsaws() != other.isKeepJigsaws()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !this$position.equals(other$position));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundJigsawGeneratePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevels();
        result = result * 59 + (this.isKeepJigsaws() ? 79 : 97);
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundJigsawGeneratePacket(position=" + this.getPosition() + ", levels=" + this.getLevels() + ", keepJigsaws=" + this.isKeepJigsaws() + ")";
    }

    public @NonNull ServerboundJigsawGeneratePacket withPosition(@lombok.NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundJigsawGeneratePacket(position, this.levels, this.keepJigsaws);
    }

    public @NonNull ServerboundJigsawGeneratePacket withLevels(int levels) {
        return this.levels == levels ? this : new ServerboundJigsawGeneratePacket(this.position, levels, this.keepJigsaws);
    }

    public @NonNull ServerboundJigsawGeneratePacket withKeepJigsaws(boolean keepJigsaws) {
        return this.keepJigsaws == keepJigsaws ? this : new ServerboundJigsawGeneratePacket(this.position, this.levels, keepJigsaws);
    }

    public ServerboundJigsawGeneratePacket(@lombok.NonNull Vector3i position, int levels, boolean keepJigsaws) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.position = position;
        this.levels = levels;
        this.keepJigsaws = keepJigsaws;
    }
}

