/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.common.adventure.adventure.text.renderer;

import cc.trixey.invero.common.adventure.adventure.text.BlockNBTComponent;
import cc.trixey.invero.common.adventure.adventure.text.BuildableComponent;
import cc.trixey.invero.common.adventure.adventure.text.Component;
import cc.trixey.invero.common.adventure.adventure.text.ComponentBuilder;
import cc.trixey.invero.common.adventure.adventure.text.EntityNBTComponent;
import cc.trixey.invero.common.adventure.adventure.text.KeybindComponent;
import cc.trixey.invero.common.adventure.adventure.text.NBTComponent;
import cc.trixey.invero.common.adventure.adventure.text.NBTComponentBuilder;
import cc.trixey.invero.common.adventure.adventure.text.ScoreComponent;
import cc.trixey.invero.common.adventure.adventure.text.SelectorComponent;
import cc.trixey.invero.common.adventure.adventure.text.StorageNBTComponent;
import cc.trixey.invero.common.adventure.adventure.text.TextComponent;
import cc.trixey.invero.common.adventure.adventure.text.TranslatableComponent;
import cc.trixey.invero.common.adventure.adventure.text.event.HoverEvent;
import cc.trixey.invero.common.adventure.adventure.text.format.Style;
import cc.trixey.invero.common.adventure.adventure.text.renderer.AbstractComponentRenderer;
import cc.trixey.invero.common.adventure.adventure.translation.Translator;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TranslatableComponentRenderer<C>
extends AbstractComponentRenderer<C> {
    private static final Set<Style.Merge> MERGES = Style.Merge.merges(Style.Merge.COLOR, Style.Merge.DECORATIONS, Style.Merge.INSERTION, Style.Merge.FONT);

    @NotNull
    public static TranslatableComponentRenderer<Locale> usingTranslationSource(final @NotNull Translator source) {
        Objects.requireNonNull(source, "source");
        return new TranslatableComponentRenderer<Locale>(){

            @Override
            @Nullable
            protected MessageFormat translate(@NotNull String key2, @NotNull Locale context2) {
                return source.translate(key2, context2);
            }
        };
    }

    @Nullable
    protected abstract MessageFormat translate(@NotNull String var1, @NotNull C var2);

    @Override
    @NotNull
    protected Component renderBlockNbt(@NotNull BlockNBTComponent component, @NotNull C context2) {
        BlockNBTComponent.Builder builder = this.nbt(context2, Component.blockNBT(), component).pos(component.pos());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    @Override
    @NotNull
    protected Component renderEntityNbt(@NotNull EntityNBTComponent component, @NotNull C context2) {
        EntityNBTComponent.Builder builder = this.nbt(context2, Component.entityNBT(), component).selector(component.selector());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    @Override
    @NotNull
    protected Component renderStorageNbt(@NotNull StorageNBTComponent component, @NotNull C context2) {
        StorageNBTComponent.Builder builder = this.nbt(context2, Component.storageNBT(), component).storage(component.storage());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    protected <O extends NBTComponent<O, B>, B extends NBTComponentBuilder<O, B>> B nbt(@NotNull C context2, B builder, O oldComponent) {
        builder.nbtPath(oldComponent.nbtPath()).interpret(oldComponent.interpret());
        @Nullable Component separator = oldComponent.separator();
        if (separator != null) {
            builder.separator(this.render(separator, context2));
        }
        return builder;
    }

    @Override
    @NotNull
    protected Component renderKeybind(@NotNull KeybindComponent component, @NotNull C context2) {
        KeybindComponent.Builder builder = Component.keybind().keybind(component.keybind());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    @Override
    @NotNull
    protected Component renderScore(@NotNull ScoreComponent component, @NotNull C context2) {
        ScoreComponent.Builder builder = Component.score().name(component.name()).objective(component.objective()).value(component.value());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    @Override
    @NotNull
    protected Component renderSelector(@NotNull SelectorComponent component, @NotNull C context2) {
        SelectorComponent.Builder builder = Component.selector().pattern(component.pattern());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    @Override
    @NotNull
    protected Component renderText(@NotNull TextComponent component, @NotNull C context2) {
        TextComponent.Builder builder = Component.text().content(component.content());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    @Override
    @NotNull
    protected Component renderTranslatable(@NotNull TranslatableComponent component, @NotNull C context2) {
        @Nullable MessageFormat format = this.translate(component.key(), context2);
        if (format == null) {
            TranslatableComponent.Builder builder = Component.translatable().key(component.key());
            if (!component.args().isEmpty()) {
                ArrayList<Component> args = new ArrayList<Component>(component.args());
                int size = args.size();
                for (int i = 0; i < size; ++i) {
                    args.set(i, this.render((Component)args.get(i), context2));
                }
                builder.args(args);
            }
            return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
        }
        List<Component> args = component.args();
        TextComponent.Builder builder = Component.text();
        this.mergeStyle(component, builder, context2);
        if (args.isEmpty()) {
            builder.content(format.format(null, new StringBuffer(), null).toString());
            return this.optionallyRenderChildrenAppendAndBuild(component.children(), builder, context2);
        }
        Object[] nulls = new Object[args.size()];
        StringBuffer sb = format.format(nulls, new StringBuffer(), (FieldPosition)null);
        AttributedCharacterIterator it = format.formatToCharacterIterator(nulls);
        while (it.getIndex() < it.getEndIndex()) {
            int end = it.getRunLimit();
            Integer index = (Integer)it.getAttribute(MessageFormat.Field.ARGUMENT);
            if (index != null) {
                builder.append(this.render(args.get(index), context2));
            } else {
                builder.append((Component)Component.text(sb.substring(it.getIndex(), end)));
            }
            it.setIndex(end);
        }
        return this.optionallyRenderChildrenAppendAndBuild(component.children(), builder, context2);
    }

    protected <O extends BuildableComponent<O, B>, B extends ComponentBuilder<O, B>> O mergeStyleAndOptionallyDeepRender(Component component, B builder, C context2) {
        this.mergeStyle(component, builder, context2);
        return this.optionallyRenderChildrenAppendAndBuild(component.children(), builder, context2);
    }

    protected <O extends BuildableComponent<O, B>, B extends ComponentBuilder<O, B>> O optionallyRenderChildrenAppendAndBuild(List<Component> children, B builder, C context2) {
        if (!children.isEmpty()) {
            children.forEach(child -> builder.append(this.render((Component)child, context2)));
        }
        return (O)builder.build();
    }

    protected <B extends ComponentBuilder<?, ?>> void mergeStyle(Component component, B builder, C context2) {
        builder.mergeStyle(component, MERGES);
        builder.clickEvent(component.clickEvent());
        @Nullable HoverEvent<?> hoverEvent = component.hoverEvent();
        if (hoverEvent != null) {
            builder.hoverEvent(hoverEvent.withRenderedValue(this, context2));
        }
    }
}

