/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.common.env;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlParser {
    private static final Pattern SUBSTITUTION_PATTERN = Pattern.compile("\\$\\{([^}]+)}");

    @NotNull
    private static String getReplacement(String key2, Element pom) throws ParseException {
        if (key2.startsWith("project.")) {
            return AbstractXmlParser.find(key2.substring("project.".length()), pom);
        }
        if (key2.startsWith("pom.")) {
            return AbstractXmlParser.find(key2.substring("pom.".length()), pom);
        }
        throw new ParseException(String.format("Unknown variable '%s'", key2), -1);
    }

    @NotNull
    private static String replaceVariables(String text, Element pom) throws ParseException {
        Matcher matcher = SUBSTITUTION_PATTERN.matcher(text);
        while (matcher.find()) {
            text = matcher.replaceFirst(AbstractXmlParser.getReplacement(matcher.group(1), pom));
        }
        return text;
    }

    @NotNull
    protected static String find(String name2, Element node2) throws ParseException {
        return AbstractXmlParser.find(name2, node2, null);
    }

    @NotNull
    protected static String find(String name2, Element node2, String def) throws ParseException {
        NodeList list2 = node2.getChildNodes();
        for (int i = 0; i < list2.getLength(); ++i) {
            Node n = list2.item(i);
            if (!n.getNodeName().equals(name2)) continue;
            try {
                return AbstractXmlParser.replaceVariables(n.getTextContent(), node2.getOwnerDocument().getDocumentElement());
            }
            catch (ParseException ex) {
                if (def == null) {
                    throw ex;
                }
                return def;
            }
        }
        list2 = node2.getElementsByTagName(name2);
        if (list2.getLength() > 0) {
            try {
                return AbstractXmlParser.replaceVariables(list2.item(0).getTextContent(), node2.getOwnerDocument().getDocumentElement());
            }
            catch (ParseException ex) {
                if (def == null) {
                    throw ex;
                }
                return def;
            }
        }
        if (def == null) {
            throw new ParseException(String.format("Unable to find required tag '%s' in node", name2), -1);
        }
        return def;
    }
}

