/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.common.inject;

import cc.trixey.invero.taboolib.common.LifeCycle;
import cc.trixey.invero.taboolib.common.TabooLibCommon;
import cc.trixey.invero.taboolib.common.inject.ClassVisitException;
import cc.trixey.invero.taboolib.common.inject.ClassVisitor;
import cc.trixey.invero.taboolib.common.inject.VisitorGroup;
import cc.trixey.invero.taboolib.common.io.Project1Kt;
import cc.trixey.invero.taboolib.common.platform.Ghost;
import cc.trixey.invero.taboolib.common.platform.PlatformFactory;
import cc.trixey.invero.taboolib.common.platform.SkipTo;
import cc.trixey.invero.taboolib.library.reflex.ClassField;
import cc.trixey.invero.taboolib.library.reflex.ClassMethod;
import cc.trixey.invero.taboolib.library.reflex.ReflexClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisitorHandler {
    private static final NavigableMap<Byte, VisitorGroup> propertyMap = Collections.synchronizedNavigableMap(new TreeMap());
    private static final List<Class<?>> classes = new ArrayList();

    public static void register(@NotNull ClassVisitor classVisitor) {
        VisitorGroup injectors = propertyMap.computeIfAbsent(classVisitor.getPriority(), i -> new VisitorGroup(classVisitor.getPriority()));
        injectors.getAll().add(classVisitor);
    }

    public static void injectAll(@NotNull Class<?> clazz) {
        for (Map.Entry entry : propertyMap.entrySet()) {
            VisitorHandler.inject(clazz, (VisitorGroup)entry.getValue(), null);
        }
    }

    public static void injectAll(@NotNull LifeCycle lifeCycle) {
        if (TabooLibCommon.isKotlinEnvironment() && !TabooLibCommon.isStopped()) {
            for (Map.Entry entry : propertyMap.entrySet()) {
                for (Class<?> clazz : VisitorHandler.getClasses()) {
                    VisitorHandler.inject(clazz, (VisitorGroup)entry.getValue(), lifeCycle);
                }
            }
        }
    }

    public static void inject(@NotNull Class<?> clazz, @NotNull VisitorGroup group, @Nullable LifeCycle lifeCycle) {
        ReflexClass reflexClass;
        int skip;
        if (TabooLibCommon.isStopped()) {
            return;
        }
        if (clazz.isAnnotationPresent(Ghost.class)) {
            return;
        }
        if (lifeCycle != null && clazz.isAnnotationPresent(SkipTo.class) && (skip = clazz.getAnnotation(SkipTo.class).value().ordinal()) > lifeCycle.ordinal()) {
            return;
        }
        Supplier<?> instance2 = Project1Kt.getInstance(clazz, false);
        try {
            reflexClass = ReflexClass.Companion.of(clazz, true);
        }
        catch (Throwable ex) {
            new ClassVisitException(clazz, ex).printStackTrace();
            return;
        }
        VisitorHandler.visitStart(clazz, group, lifeCycle, reflexClass, instance2);
        VisitorHandler.visitField(clazz, group, lifeCycle, reflexClass, instance2);
        VisitorHandler.visitMethod(clazz, group, lifeCycle, reflexClass, instance2);
        VisitorHandler.visitEnd(clazz, group, lifeCycle, reflexClass, instance2);
    }

    private static void visitStart(Class<?> clazz, VisitorGroup group, LifeCycle lifeCycle, ReflexClass reflexClass, Supplier<?> instance2) {
        for (ClassVisitor visitor : group.get(lifeCycle)) {
            try {
                visitor.visitStart(clazz, instance2);
            }
            catch (Throwable ex) {
                new ClassVisitException(clazz, group, lifeCycle, ex).printStackTrace();
            }
        }
    }

    private static void visitField(Class<?> clazz, VisitorGroup group, LifeCycle lifeCycle, ReflexClass reflexClass, Supplier<?> instance2) {
        for (ClassVisitor visitor : group.get(lifeCycle)) {
            for (ClassField field : reflexClass.getStructure().getFields()) {
                try {
                    visitor.visit(field, clazz, instance2);
                }
                catch (Throwable ex) {
                    new ClassVisitException(clazz, group, lifeCycle, field, ex).printStackTrace();
                }
            }
        }
    }

    private static void visitMethod(Class<?> clazz, VisitorGroup group, LifeCycle lifeCycle, ReflexClass reflexClass, Supplier<?> instance2) {
        for (ClassVisitor visitor : group.get(lifeCycle)) {
            for (ClassMethod method2 : reflexClass.getStructure().getMethods()) {
                try {
                    visitor.visit(method2, clazz, instance2);
                }
                catch (Throwable ex) {
                    new ClassVisitException(clazz, group, lifeCycle, method2, ex).printStackTrace();
                }
            }
        }
    }

    private static void visitEnd(Class<?> clazz, VisitorGroup group, LifeCycle lifeCycle, ReflexClass reflexClass, Supplier<?> instance2) {
        for (ClassVisitor visitor : group.get(lifeCycle)) {
            try {
                visitor.visitEnd(clazz, instance2);
            }
            catch (Throwable ex) {
                new ClassVisitException(clazz, group, lifeCycle, ex).printStackTrace();
            }
        }
    }

    private static List<Class<?>> getClasses() {
        if (classes.isEmpty()) {
            for (Class clazz : Project1Kt.getRunningClasses()) {
                if (!PlatformFactory.INSTANCE.checkPlatform(clazz)) continue;
                classes.add(clazz);
            }
        }
        return classes;
    }
}

