/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.common.platform.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin1810.collections.ArraysKt;
import kotlin1810.jvm.internal.Intrinsics;
import kotlin1810.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020&J\u0006\u0010(\u001a\u00020&J\u0006\u0010)\u001a\u00020\u0000J\u0019\u0010*\u001a\u00020&*\u00060\u0018j\u0002`\u00192\u0006\u0010+\u001a\u00020\u000bH\u0086\u0002J\u0019\u0010*\u001a\u00020&*\u00060\u0018j\u0002`\u00192\u0006\u0010,\u001a\u00020\u0003H\u0086\u0002J\u001d\u0010*\u001a\u00020&*\u00060\u0018j\u0002`\u00192\n\u0010,\u001a\u00060\u0018j\u0002`\u0019H\u0086\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0015\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u0016R\u0015\u0010#\u001a\u00060\u0018j\u0002`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001b\u00a8\u0006-"}, d2={"Lcc/trixey/invero/taboolib/common/platform/command/CommandLineParser;", "", "line", "", "(Ljava/lang/String;)V", "args", "", "getArgs", "()Ljava/util/List;", "escapes", "", "", "getEscapes", "()[Ljava/lang/Character;", "[Ljava/lang/Character;", "getLine", "()Ljava/lang/String;", "option", "", "getOption", "()Z", "setOption", "(Z)V", "optionName", "Ljava/lang/StringBuilder;", "Lkotlin1810/text/StringBuilder;", "getOptionName", "()Ljava/lang/StringBuilder;", "options", "", "getOptions", "()Ljava/util/Map;", "quote", "getQuote", "setQuote", "value", "getValue", "close", "", "closeOption", "closeValue", "parse", "plusAssign", "c", "s", "common"})
public final class CommandLineParser {
    @NotNull
    private final String line;
    @NotNull
    private final Character[] escapes;
    @NotNull
    private final Map<String, String> options;
    @NotNull
    private final List<String> args;
    @NotNull
    private final StringBuilder value;
    private boolean quote;
    private boolean option;
    @NotNull
    private final StringBuilder optionName;

    public CommandLineParser(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.line = line;
        Character[] characterArray = new Character[]{Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('='), Character.valueOf('-'), Character.valueOf(':'), Character.valueOf('\\')};
        this.escapes = characterArray;
        boolean bl = false;
        this.options = new LinkedHashMap();
        bl = false;
        this.args = new ArrayList();
        this.value = new StringBuilder();
        this.optionName = new StringBuilder();
    }

    @NotNull
    public final String getLine() {
        return this.line;
    }

    @NotNull
    public final Character[] getEscapes() {
        return this.escapes;
    }

    @NotNull
    public final Map<String, String> getOptions() {
        return this.options;
    }

    @NotNull
    public final List<String> getArgs() {
        return this.args;
    }

    @NotNull
    public final StringBuilder getValue() {
        return this.value;
    }

    public final boolean getQuote() {
        return this.quote;
    }

    public final void setQuote(boolean bl) {
        this.quote = bl;
    }

    public final boolean getOption() {
        return this.option;
    }

    public final void setOption(boolean bl) {
        this.option = bl;
    }

    @NotNull
    public final StringBuilder getOptionName() {
        return this.optionName;
    }

    @NotNull
    public final CommandLineParser parse() {
        int i = 0;
        int len = this.line.length();
        while (i < len) {
            CommandLineParser commandLineParser;
            char c = this.line.charAt(i);
            if (c == '\\' && i + 1 < this.line.length() && ArraysKt.contains((Object[])this.escapes, (Object)Character.valueOf(this.line.charAt(i + 1)))) {
                commandLineParser = this;
                this.plusAssign(commandLineParser.value, this.line.charAt(i + 1));
                i += 2;
                continue;
            }
            if (c == '\'' || c == '\"') {
                if (this.quote) {
                    this.close();
                }
                this.quote = !this.quote;
                int n = i;
                i = n + 1;
                continue;
            }
            if (c == ' ' && !this.quote) {
                this.close();
                int n = i;
                i = n + 1;
                continue;
            }
            if (c == '-' && !this.quote) {
                this.option = true;
                int n = i;
                i = n + 1;
                continue;
            }
            if (this.option && c == '=' || c == ':') {
                commandLineParser = this;
                this.plusAssign(commandLineParser.optionName, this.value);
                StringsKt.clear((StringBuilder)this.value);
                int n = i;
                i = n + 1;
                continue;
            }
            commandLineParser = this;
            this.plusAssign(commandLineParser.value, c);
            int n = i;
            i = n + 1;
        }
        this.close();
        return this;
    }

    public final void close() {
        this.closeOption();
        this.closeValue();
    }

    public final void closeValue() {
        Object object = this.value;
        boolean bl = false;
        if (object.length() > 0) {
            object = this;
            Collection collection = ((CommandLineParser)object).args;
            String string = this.value.toString();
            boolean bl2 = false;
            collection.add(string);
            StringsKt.clear((StringBuilder)this.value);
        }
    }

    public final void closeOption() {
        if (this.option) {
            Map<String, String> map2 = this.optionName;
            boolean bl = false;
            if (map2.length() > 0) {
                map2 = this.options;
                String string = this.optionName.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optionName.toString()");
                String string2 = this.value.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.toString()");
                boolean bl2 = false;
                map2.put(string, string2);
            } else {
                map2 = this.options;
                String string = this.value.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.toString()");
                String string3 = "";
                boolean bl3 = false;
                map2.put(string, string3);
            }
            StringsKt.clear((StringBuilder)this.optionName);
            StringsKt.clear((StringBuilder)this.value);
            this.option = false;
        }
    }

    public final void plusAssign(@NotNull StringBuilder $this$plusAssign, char c) {
        Intrinsics.checkNotNullParameter((Object)$this$plusAssign, (String)"<this>");
        $this$plusAssign.append(c);
    }

    public final void plusAssign(@NotNull StringBuilder $this$plusAssign, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)$this$plusAssign, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        $this$plusAssign.append(s);
    }

    public final void plusAssign(@NotNull StringBuilder $this$plusAssign, @NotNull StringBuilder s) {
        Intrinsics.checkNotNullParameter((Object)$this$plusAssign, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        $this$plusAssign.append((CharSequence)s);
    }
}

