/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.common5;

import cc.trixey.invero.taboolib.common.Isolated;
import cc.trixey.invero.taboolib.common.LifeCycle;
import cc.trixey.invero.taboolib.common.env.RuntimeDependency;
import cc.trixey.invero.taboolib.common.platform.Awake;
import cc.trixey.invero.taboolib.common.platform.Releasable;
import cc.trixey.invero.taboolib.common.platform.SkipTo;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.tuple.Triple;

@Awake
@SkipTo(value=LifeCycle.ENABLE)
@RuntimeDependency(value="!org.apache.commons:commons-lang3:3.5", test="!org.apache.commons.lang3.concurrent.BasicThreadFactory")
@Isolated
public class FileWatcher
implements Releasable {
    public static final FileWatcher INSTANCE = new FileWatcher();
    private final ScheduledExecutorService service = Executors.newScheduledThreadPool(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("TConfigWatcherService-%d").build());
    private final Map<WatchService, Triple<File, Object, Consumer<Object>>> map = new HashMap<WatchService, Triple<File, Object, Consumer<Object>>>();

    public FileWatcher() {
        this.service.scheduleAtFixedRate(() -> {
            Map<WatchService, Triple<File, Object, Consumer<Object>>> map2 = this.map;
            synchronized (map2) {
                this.map.forEach((service, triple) -> {
                    WatchKey key2;
                    while ((key2 = service.poll()) != null) {
                        for (WatchEvent<?> watchEvent : key2.pollEvents()) {
                            if (!((File)triple.getLeft()).getName().equals(Objects.toString(watchEvent.context()))) continue;
                            ((Consumer)triple.getRight()).accept(triple.getMiddle());
                        }
                        key2.reset();
                    }
                });
            }
        }, 1000L, 100L, TimeUnit.MILLISECONDS);
    }

    public void addSimpleListener(File file, Runnable runnable) {
        this.addSimpleListener(file, runnable, false);
    }

    public void addSimpleListener(File file, Runnable runnable, boolean runFirst) {
        if (runFirst) {
            runnable.run();
        }
        try {
            this.addListener(file, null, obj -> runnable.run());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addOnListen(File file, Object obj, Consumer<Object> consumer) {
        try {
            WatchService service = FileSystems.getDefault().newWatchService();
            file.getParentFile().toPath().register(service, StandardWatchEventKinds.ENTRY_MODIFY);
            this.map.putIfAbsent(service, (Triple<File, Object, Consumer<Object>>)Triple.of((Object)file, (Object)obj, consumer));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public <T> void addListener(File file, T obj, Consumer<T> consumer) {
        this.addOnListen(file, obj, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListener(File file) {
        Map<WatchService, Triple<File, Object, Consumer<Object>>> map2 = this.map;
        synchronized (map2) {
            return this.map.values().stream().anyMatch(t -> ((File)t.getLeft()).getPath().equals(file.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runListener(File file) {
        Map<WatchService, Triple<File, Object, Consumer<Object>>> map2 = this.map;
        synchronized (map2) {
            this.map.values().stream().filter(t -> ((File)t.getLeft()).getPath().equals(file.getPath())).forEach(f -> ((Consumer)f.getRight()).accept(null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(File file) {
        Map<WatchService, Triple<File, Object, Consumer<Object>>> map2 = this.map;
        synchronized (map2) {
            this.map.entrySet().removeIf(entry -> {
                if (((File)((Triple)entry.getValue()).getLeft()).getPath().equals(file.getPath())) {
                    try {
                        ((WatchService)entry.getKey()).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return true;
                }
                return false;
            });
        }
    }

    public void unregisterAll() {
        this.service.shutdown();
        this.map.forEach((service, pair) -> {
            try {
                service.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        });
    }

    @Override
    public void release() {
        this.unregisterAll();
    }
}

