/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.module.nms;

import cc.trixey.invero.taboolib.common.Isolated;
import cc.trixey.invero.taboolib.library.reflex.ClassField;
import cc.trixey.invero.taboolib.library.reflex.ClassMethod;
import cc.trixey.invero.taboolib.library.reflex.ReflexClass;
import cc.trixey.invero.taboolib.module.nms.MinecraftServerUtilKt;
import cc.trixey.invero.taboolib.module.nms.MinecraftVersion;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.attribute.Attribute;

@Isolated
public enum BukkitAttribute {
    MAX_HEALTH("generic.maxHealth", new String[]{"health", "maxHealth"}),
    FOLLOW_RANGE("generic.followRange", new String[]{"follow", "followRange"}),
    KNOCKBACK_RESISTANCE("generic.knockbackResistance", new String[]{"knockback", "knockbackResistance"}),
    MOVEMENT_SPEED("generic.movementSpeed", new String[]{"speed", "movementSpeed", "walkSpeed"}),
    FLYING_SPEED("generic.flyingSpeed", new String[]{"flySpeed", "flyingSpeed"}),
    ATTACK_DAMAGE("generic.attackDamage", new String[]{"damage", "attackDamage"}),
    ATTACK_KNOCKBACK("generic.attackKnockback", new String[]{"damageKnockback", "attackKnockback"}),
    ATTACK_SPEED("generic.attackSpeed", new String[]{"damageSpeed", "attackSpeed"}),
    ARMOR("generic.armor", new String[]{"armor"}),
    ARMOR_TOUGHNESS("generic.armorToughness", new String[]{"toughness", "armorToughness"}),
    LUCK("generic.luck", new String[]{"luck"});

    final String minecraftKey;
    final String[] simplifiedKey;

    private BukkitAttribute(String minecraftKey, String[] simplifiedKey) {
        this.minecraftKey = minecraftKey;
        this.simplifiedKey = simplifiedKey;
    }

    public static BukkitAttribute parse(String source) {
        return Arrays.stream(BukkitAttribute.values()).filter(attribute -> attribute.match(source)).findFirst().orElse(null);
    }

    public String getMinecraftKey() {
        return this.minecraftKey;
    }

    public String[] getSimplifiedKey() {
        return this.simplifiedKey;
    }

    public Attribute toBukkit() {
        Attribute attribute;
        try {
            attribute = Attribute.valueOf((String)("GENERIC_" + this.name()));
        }
        catch (Exception e2) {
            attribute = Attribute.valueOf((String)this.name());
        }
        return attribute;
    }

    public Object toNMS() {
        ReflexClass genericAttributesClass = ReflexClass.Companion.of(MinecraftServerUtilKt.nmsClass("GenericAttributes"), true);
        ReflexClass attributeBaseClass = ReflexClass.Companion.of(MinecraftServerUtilKt.nmsClass("AttributeBase"), true);
        if (MinecraftVersion.INSTANCE.getMajorLegacy() <= 11300) {
            ClassMethod method2 = attributeBaseClass.getMethod("getName", false, false, new Object[0]);
            for (ClassField classField : genericAttributesClass.getStructure().getFields()) {
                Object attribute = classField.get(null);
                if (!Objects.requireNonNull(Objects.requireNonNull(method2.invoke(attributeBaseClass.getStructure().getOwner().cast(attribute), new Object[0]))).equals(this.minecraftKey)) continue;
                return attribute;
            }
        } else {
            return genericAttributesClass.getField(this.name(), false, true).get(null);
        }
        return null;
    }

    public boolean match(String source) {
        return this.name().equalsIgnoreCase(source) || this.minecraftKey.equalsIgnoreCase(source) || Arrays.stream(this.simplifiedKey).anyMatch(key2 -> key2.equalsIgnoreCase(source));
    }
}

