/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.data.managers.KingdomManager;
import org.kingdoms.data.managers.NationManager;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.string.QuantumString;
import org.kingdoms.utils.string.StringUtils;

public class CommandTabContext
extends CommandContext {
    public CommandTabContext(Kingdoms plugin, KingdomsCommand command, CommandSender sender, String[] args) {
        super(plugin, command, sender, args);
    }

    public static @NonNull List<String> getKingdomMembers(@NonNull Nation nation, @Nullable String starts, @Nullable Predicate<Kingdom> predicate) {
        List<Kingdom> kingdoms = nation.getKingdoms();
        ArrayList<String> names = new ArrayList<String>(kingdoms.size());
        boolean empty = starts.isEmpty();
        for (Kingdom kingdom : kingdoms) {
            String name = kingdom.getName();
            if (!empty && !name.toLowerCase(Locale.ENGLISH).startsWith(starts) || predicate != null && !predicate.test(kingdom)) continue;
            names.add(name);
        }
        return names;
    }

    private static @NonNull List<String> getGroups(@NonNull Map<QuantumString, UUID> names, @Nullable QuantumString starts, @Nullable Predicate<String> predicate) {
        ArrayList<String> groups = new ArrayList<String>(Math.max(names.size() / Math.max(1, starts.length()), 30));
        String startsqBit = starts.getQuantum();
        for (QuantumString name : names.keySet()) {
            String quantum = name.getQuantum();
            if (predicate != null && !predicate.test(quantum)) continue;
            if (starts.isEmpty()) {
                groups.add(quantum);
                continue;
            }
            if (!name.getQuantum().startsWith(startsqBit)) continue;
            groups.add(quantum);
        }
        return groups;
    }

    public String tab(String path) {
        String obj = this.lang("tab-completion", path).parse(this.settings);
        return obj == null ? "" : obj;
    }

    public static @NonNull List<String> getNations(@Nullable String starts) {
        return CommandTabContext.getNations(starts, null);
    }

    public static @NonNull List<String> getNations(@Nullable String starts, @Nullable Predicate<String> predicate) {
        return CommandTabContext.getGroups(NationManager.getNames(), NationManager.toQuantumName(starts), predicate);
    }

    public Stream<String> filter(Stream<String> stream, int index) {
        return !this.assertArgs(index - 1) ? stream : stream.filter(x -> x.startsWith(this.arg(index)));
    }

    public List<String> suggest(int index, Collection<String> items) {
        return this.suggest(index, items.toArray(new String[0]));
    }

    public List<String> suggest(int index, String ... items) {
        String starts = this.arg(index);
        if (starts.isEmpty()) {
            return Arrays.asList(items);
        }
        ArrayList<String> suggestions = new ArrayList<String>(items.length);
        starts = StringUtils.toLatinLowerCase(starts);
        for (String item : items) {
            if (!StringUtils.toLatinLowerCase(item).startsWith(starts)) continue;
            suggestions.add(item);
        }
        if (suggestions.size() <= 5) {
            for (String item : items) {
                if (!StringUtils.toLatinLowerCase(item).contains(starts)) continue;
                suggestions.add(item);
            }
        }
        return suggestions;
    }

    public List<String> getChannels(int index, Predicate<KingdomsChatChannel> filter) {
        return this.suggest(index, (String[])KingdomsChatChannel.getChannels().values().stream().filter(filter).map(x -> x.getName().buildPlain(this.getSettings())).toArray(String[]::new));
    }

    public @NonNull List<String> getPlayers(int index) {
        return this.getPlayers(index, null);
    }

    public List<String> add(List<String> list2, String ... others) {
        list2.addAll(Arrays.asList(others));
        return list2;
    }

    public @NonNull List<String> getPlayers(int index, Predicate<OfflinePlayer> filter) {
        return this.getPlayers(Bukkit.getOnlinePlayers(), this.arg(index), false, filter);
    }

    public @NonNull List<String> getPlayers(Collection<? extends OfflinePlayer> players, @NonNull String starts, boolean admin, Predicate<OfflinePlayer> filter) {
        return TabCompleteManager.getPlayers(players, starts, admin, filter);
    }

    public String currentArg() {
        return this.args[this.args.length - 1];
    }

    public @NonNull List<String> getKingdomPlayers(@NonNull Kingdom kingdom, int index) {
        return this.getPlayers(kingdom.getPlayerMembers(), this.arg(index), true, null);
    }

    public @NonNull List<String> getKingdomPlayers(@NonNull Kingdom kingdom, @NonNull String starts, Predicate<OfflinePlayer> filter) {
        return this.getPlayers(kingdom.getPlayerMembers(), starts, true, filter);
    }

    public @NonNull List<String> getKingdoms(int index) {
        return this.getKingdoms(index, null);
    }

    public @NonNull List<String> getKingdoms(int index, @Nullable Predicate<String> predicate) {
        return CommandTabContext.getGroups(KingdomManager.getNames(), this.assertArgs(index + 1) ? KingdomManager.toQuantumName(this.arg(index)) : QuantumString.empty(), predicate);
    }

    public <T extends Group> List<String> tabCompleteGeneralSelector(boolean targetNation, boolean includeIfNotExist, Predicate<T> filter) {
        String startsWith;
        int from = this.nextArg();
        if (this.args.length - 1 < from || this.args.length - 1 > from + 1) {
            return new ArrayList<String>();
        }
        String playerTag = KingdomsLang.COMMANDS_TAGS_IDENTIFIER_PLAYERS.parse(this.sender, new Object[0]);
        String kingdomTag = KingdomsLang.COMMANDS_TAGS_IDENTIFIER_KINGDOMS.parse(this.sender, new Object[0]);
        String nationTag = KingdomsLang.COMMANDS_TAGS_IDENTIFIER_NATIONS.parse(this.sender, new Object[0]);
        ArrayList<String> list2 = new ArrayList<String>();
        boolean addPlayerNames = false;
        boolean addKingdomNames = false;
        boolean addNationNames = false;
        if (this.args.length - 1 == from) {
            startsWith = this.args[from];
            list2.add(playerTag);
            list2.add(kingdomTag);
            if (targetNation) {
                list2.add(nationTag);
            }
            if (startsWith.isEmpty()) {
                list2.add(KingdomsLang.COMMANDS_TAGS_PLAYERS.parse(this.sender, new Object[0]));
                list2.add(KingdomsLang.COMMANDS_TAGS_KINGDOMS.parse(this.sender, new Object[0]));
                if (targetNation) {
                    list2.add(KingdomsLang.COMMANDS_TAGS_NATIONS.parse(this.sender, new Object[0]));
                }
            } else {
                addNationNames = true;
                addKingdomNames = true;
                addPlayerNames = true;
            }
        } else {
            startsWith = this.args[this.nextArg()];
            String previous = this.args[from].toLowerCase();
            if (previous.equals(playerTag.toLowerCase())) {
                addPlayerNames = true;
            } else if (previous.equals(kingdomTag.toLowerCase())) {
                addKingdomNames = true;
            } else if (targetNation && previous.equals(nationTag.toLowerCase())) {
                addNationNames = true;
            }
        }
        if (addPlayerNames) {
            list2.addAll(TabCompleteManager.getPlayers(startsWith, player -> {
                Kingdom kingdom;
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player);
                Group group = kingdom = kp.getKingdom();
                if (targetNation) {
                    group = kingdom.getNation();
                }
                if (group == null) {
                    return includeIfNotExist;
                }
                return filter.test(group);
            }));
        }
        if (addKingdomNames) {
            list2.addAll(TabCompleteManager.getKingdoms(startsWith, kingdomName -> {
                Kingdom kingdom;
                Group group = kingdom = Kingdom.getKingdom(kingdomName);
                if (targetNation) {
                    group = kingdom.getNation();
                }
                if (group == null) {
                    return includeIfNotExist;
                }
                return filter.test(group);
            }));
        }
        if (addNationNames) {
            list2.addAll(TabCompleteManager.getNations(startsWith, nationName -> filter.test(Nation.getNation(nationName))));
        }
        return list2;
    }

    public @NonNull List<String> getNations(int index, @Nullable Predicate<String> predicate) {
        return CommandTabContext.getGroups(NationManager.getNames(), this.assertArgs(index + 1) ? KingdomManager.toQuantumName(this.arg(index)) : QuantumString.empty(), predicate);
    }
}

