/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;

public abstract class KingdomsParentCommand
extends KingdomsCommand {
    protected final Map<SupportedLanguage, Map<String, KingdomsCommand>> children = new QuickEnumMap((Enum[])SupportedLanguage.VALUES);

    public KingdomsParentCommand(@NonNull String name, @Nullable KingdomsParentCommand parent) {
        super(name, parent, null);
    }

    public KingdomsParentCommand(@NonNull String name, boolean playerCmd) {
        super(name, playerCmd);
    }

    public KingdomsParentCommand(@NonNull String name) {
        super(name, false);
    }

    public final @NonNull Collection<KingdomsCommand> getChildren(SupportedLanguage language) {
        return Objects.requireNonNull(this.children.get((Object)language), () -> "Null children for command '" + this.name + "' for language: " + (Object)((Object)language)).values();
    }

    public Map<SupportedLanguage, Map<String, KingdomsCommand>> getChildren() {
        return this.children;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        return context.isAtArg(0) ? TabCompleteManager.getSubCommand(context.getSender(), this, context.args) : KingdomsParentCommand.emptyTab();
    }

    @Override
    public void execute(CommandContext context) {
        Set filtered = Collections.newSetFromMap(new IdentityHashMap(30));
        boolean isAdmin = context.isPlayer() && context.getKingdomPlayer().isAdmin();
        KingdomsCommand[] subCommands = (KingdomsCommand[])this.getChildren(context.getSettings().getLanguage()).stream().filter(filtered::add).filter(c -> isAdmin || c.hasPermission(context.getSender())).toArray(KingdomsCommand[]::new);
        context.sendMessage(KingdomsLang.COMMAND_HELP_GROUPED_HEADER, "group", this.getDisplayName());
        for (KingdomsCommand cmd : subCommands) {
            StringBuilder name = new StringBuilder(cmd.getDisplayName().parse(context.getSettings()));
            for (KingdomsParentCommand group = cmd.getParent(); group != null; group = group.getParent()) {
                name.insert(0, group.getDisplayName().parse(context.getSettings()) + ' ');
            }
            context.sendMessage(KingdomsLang.COMMAND_HELP_GROUPED_COMMANDS, "cmd", name, "description", cmd.getDescription().parse(context.getSender(), new Object[0]));
        }
    }
}

