/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.SetterHandler;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.string.StringUtils;

public class CommandAdminBank
extends KingdomsCommand {
    public CommandAdminBank(KingdomsParentCommand parent) {
        super("bank", parent);
    }

    @Override
    public void execute(CommandContext context) {
        String number;
        String action;
        if (context.requireArgs(2)) {
            return;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return;
        }
        String[] args = context.args;
        CommandSender sender = context.getSender();
        if (args.length > 2) {
            action = args[1];
            number = args[2];
        } else {
            action = "add";
            number = args[1];
        }
        double old = kingdom.getBank();
        SetterHandler.SetterResult result = SetterHandler.eval(action, old, number);
        if (result == SetterHandler.SetterResult.NOT_NUMBER) {
            KingdomsLang.INVALID_NUMBER.sendMessage(sender, "arg", number);
            return;
        }
        if (result == SetterHandler.SetterResult.UNKNOWN) {
            KingdomsLang.COMMAND_ADMIN_BANK_INVALID_ACTION.sendMessage(sender, "action", action);
            return;
        }
        kingdom.setBank(result.getValue());
        String fancyBal = StringUtils.toFancyNumber(old);
        MessageBuilder settings = new MessageBuilder().raws("bank", fancyBal, "kingdom", kingdom.getName()).withContext(kingdom);
        KingdomsLang.COMMAND_ADMIN_BANK_DONE.sendMessage(sender, settings);
        for (Player member : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_ADMIN_BANK_ADDED.sendMessage((CommandSender)member, settings);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return TabCompleteManager.getKingdoms(args[0]);
        }
        if (args.length == 2) {
            return SetterHandler.tabComplete(args[1]);
        }
        if (args.length == 3) {
            return CommandAdminBank.tabComplete("<amount>");
        }
        return CommandAdminBank.emptyTab();
    }
}

