/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.string.StringUtils;

public class CommandAdminCommands
extends KingdomsCommand {
    private static final String OUTPUT_FILE = "command-permissions.txt";

    public CommandAdminCommands(KingdomsParentCommand parent) {
        super("commands", parent);
    }

    @Override
    public void execute(CommandContext context) {
        boolean defaultsOnly = false;
        if (context.assertArgs(1) && context.arg(0).equalsIgnoreCase("defaults")) {
            defaultsOnly = true;
        }
        Path path = Kingdoms.get().getDataFolder().toPath().resolve(OUTPUT_FILE);
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            for (KingdomsCommand cmd : KingdomsCommandHandler.getCommands(SupportedLanguage.EN).values()) {
                if (defaultsOnly && cmd.getPermission().getDefault() != PermissionDefault.TRUE) continue;
                writer.write(cmd.getName() + " (" + StringUtils.join(cmd.getAliases().get((Object)SupportedLanguage.EN).toArray(), ", ") + ") " + cmd.getPermission().getName());
                writer.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_COMMANDS_DONE, "output", OUTPUT_FILE);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        return context.isAtArg(0) ? CommandAdminCommands.tabComplete("defaults") : CommandAdminCommands.emptyTab();
    }
}

