/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandAdminDisband
extends KingdomsCommand {
    public CommandAdminDisband(KingdomsParentCommand parent) {
        super("disband", parent);
    }

    @Override
    public void execute(CommandContext context) {
        Kingdom kingdom;
        if (!context.assertArgs(1)) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_DISBAND_USAGE, new Object[0]);
            return;
        }
        boolean silent = false;
        int silentArgIndex = 1;
        if (context.argEquals(0, KingdomsLang.COMMANDS_TAGS_PLAYERS)) {
            Player player = context.getPlayer(1);
            if (player == null) {
                return;
            }
            kingdom = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player).getKingdom();
            if (kingdom == null) {
                context.sendError(KingdomsLang.NO_KINGDOM_TARGET, new Object[0]);
                return;
            }
            ++silentArgIndex;
        } else {
            kingdom = context.getKingdom(0);
            if (kingdom == null) {
                return;
            }
        }
        if (kingdom.triggerDisbandEvent(GroupDisband.Reason.ADMIN).isCancelled()) {
            return;
        }
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_DISBAND_SUCCESS, "kingdom", kingdom.getName());
        if (context.assertArgs(3) && context.arg(silentArgIndex).equals("silent") && KingdomsConfig.DISBAND_ANNOUNCE.getBoolean()) {
            for (Player players : Bukkit.getOnlinePlayers()) {
                KingdomsLang.COMMAND_ADMIN_DISBAND_ANNOUNCE.sendMessage((CommandSender)players, "player", context.getSender().getName(), "kingdom", kingdom.getName());
            }
        }
        kingdom.disband(null);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            @NonNull List<String> list2 = context.getKingdoms(0);
            list2.add(KingdomsLang.COMMANDS_TAGS_PLAYERS.parse(new Object[0]));
            return list2;
        }
        if (context.isAtArg(1)) {
            if (context.argEquals(0, KingdomsLang.COMMANDS_TAGS_PLAYERS)) {
                return context.getPlayers(1);
            }
            return CommandAdminDisband.tabComplete("silent");
        }
        if (context.isAtArg(2) && context.argEquals(0, KingdomsLang.COMMANDS_TAGS_PLAYERS)) {
            return CommandAdminDisband.tabComplete("silent");
        }
        return CommandAdminDisband.emptyTab();
    }
}

