/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import com.google.common.base.Strings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.data.Pair;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.GUIOption;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.gui.objects.ConditionalGUIOptionObject;
import org.kingdoms.gui.objects.GUIOptionBuilder;
import org.kingdoms.gui.objects.GUIOptionObject;
import org.kingdoms.gui.objects.GUIOptionParser;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.snakeyaml.common.ScalarStyle;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.libs.snakeyaml.nodes.Tag;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessagePiece;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.adapters.YamlFile;
import org.kingdoms.utils.string.StringUtils;

public class CommandAdminGUI
extends KingdomsCommand
implements Listener {
    private static final Map<UUID, String> VIEWING = new HashMap<UUID, String>();

    public CommandAdminGUI(KingdomsParentCommand parent) {
        super("gui", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        UUID id = context.senderAsPlayer().getUniqueId();
        if (context.assertArgs(1)) {
            String guiName = StringUtils.remove(context.arg(0).replace('.', '/').replace('\\', '/').toLowerCase(Locale.ENGLISH), ".yml");
            if (!SupportedLanguage.EN.getGUIs().containsKey(guiName)) {
                context.sendError(KingdomsLang.COMMAND_GUI_NOT_FOUND, "gui", guiName);
                return;
            }
            VIEWING.put(id, guiName);
            Player player = context.senderAsPlayer();
            InventoryInteractiveGUI gui = (InventoryInteractiveGUI)new GUIBuilder(guiName).forPlayer(player).inventoryGUIOnly().build();
            Inventory inv = gui.getInventory();
            for (Map.Entry<String, GUIOptionBuilder> left : gui.getRemainingOptions().entrySet()) {
                GUIOptionBuilder optionBuilder = left.getValue();
                while (optionBuilder instanceof ConditionalGUIOptionObject) {
                    ConditionalGUIOptionObject cond = (ConditionalGUIOptionObject)optionBuilder;
                    optionBuilder = cond.getOptions()[0].getObject();
                }
                GUIOptionObject optionObject = (GUIOptionObject)optionBuilder;
                GUIOption option = new GUIOption(left.getKey(), optionObject);
                for (int slot : option.getSettings().getSlots()) {
                    inv.setItem(slot, option.getSettings().getItem().clone());
                }
            }
            player.openInventory(inv);
            return;
        }
        if (VIEWING.containsKey(id)) {
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_GUI_DISABLED, new Object[0]);
            VIEWING.remove(id);
        } else {
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_GUI_ENABLED, new Object[0]);
            VIEWING.put(id, "");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        String guiName = VIEWING.remove(player.getUniqueId());
        if (guiName == null || guiName.isEmpty()) {
            return;
        }
        Path file = CommandAdminGUI.serializeInventory(event.getInventory());
        KingdomsLang.COMMAND_ADMIN_GUI_DONE.sendMessage((CommandSender)player, "file", file.getFileName());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        String guiName = VIEWING.get(player.getUniqueId());
        if (guiName == null || !guiName.isEmpty()) {
            return;
        }
        VIEWING.remove(player.getUniqueId());
        KingdomsLang.COMMAND_ADMIN_GUI_OPENED.sendMessage((CommandSender)player);
        Path file = CommandAdminGUI.serializeInventory(event.getInventory());
        player.closeInventory();
        KingdomsLang.COMMAND_ADMIN_GUI_DONE.sendMessage((CommandSender)player, "file", file.getFileName());
    }

    public static Path serializeInventory(Inventory inventory) {
        Path file;
        Path path = Kingdoms.get().getDataFolder().toPath();
        int i = 0;
        while (Files.exists(file = path.resolve("parsed-gui-" + i + ".yml"), new LinkOption[0])) {
            ++i;
        }
        YamlFile adapter = new YamlFile(file.toFile()).load();
        ConfigSection config = adapter.getConfig();
        config.set("title", (Object)("{$sep}-=( {$p}" + inventory.getType().name().toLowerCase() + " {$sep})=-"));
        if (inventory.getType() == InventoryType.CHEST) {
            config.set("rows", (Object)((inventory.getSize() + 1) / 9));
        } else {
            config.set("type", (Object)inventory.getType().name());
        }
        ConfigSection items = config.createSection("options");
        ItemStack[] content = inventory.getContents();
        Pair[] added = new Pair[content.length];
        for (i = 0; i < content.length; ++i) {
            ItemStack item = content[i];
            if (item == null) continue;
            boolean isSimilar = false;
            for (int j = 0; j < i; ++j) {
                Pair other = added[j];
                if (other == null || !item.equals(other.getKey())) continue;
                ((List)other.getValue()).add(i);
                isSimilar = true;
                break;
            }
            if (isSimilar) continue;
            ArrayList<Integer> slots = new ArrayList<Integer>(1);
            slots.add(i);
            added[i] = Pair.of(item, slots);
        }
        HashSet<String> taken = new HashSet<String>();
        for (Pair result : added) {
            String name;
            if (result == null) continue;
            ItemStack item = (ItemStack)result.getKey();
            String finalName = name = StringUtils.replace(item.getType().name().toLowerCase(Locale.ENGLISH), '_', '-').toString();
            while (!taken.add(finalName)) {
                finalName = name + i++;
            }
            ConfigSection section = items.createSection(finalName);
            List slots = (List)result.getValue();
            if (slots.size() == 1) {
                if (inventory.getType() == InventoryType.CHEST) {
                    int[] pos = GUIOptionParser.rawSlotToXY((Integer)slots.get(0));
                    section.set("posx", (Object)pos[0]);
                    section.set("posy", (Object)pos[1]);
                } else {
                    section.set("slot", slots.get(0));
                }
            } else {
                section.set("slots", (Object)slots);
            }
            XItemStack.serialize(item, section.toBukkitConfigurationSection());
            section.set("flags", null);
            if (Strings.isNullOrEmpty((String)section.getString("name"))) {
                section.set("name", (Object)"");
            } else {
                String optionName = section.getString("name");
                MessageCompiler compiled = new MessageCompiler(optionName, new MessageCompilerSettings(false, false, true, false, false, null));
                boolean containsFormatting = compiled.compileObject().hasPiece(x -> x instanceof MessagePiece.Color || x instanceof MessagePiece.Hover);
                section.set("name", (Object)((containsFormatting ? "" : "{$p}") + optionName));
            }
            List<String> lore = section.getStringList("lore");
            if (lore.size() <= 1) continue;
            section.set("lore", (Object)new ScalarNode(Tag.STR, String.join((CharSequence)"\n", lore), ScalarStyle.LITERAL));
        }
        adapter.saveConfig();
        return file;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.suggest(0, SupportedLanguage.EN.getGUIs().keySet());
        }
        return CommandAdminGUI.emptyTab();
    }
}

