/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.Masswar;

public class CommandAdminMasswar
extends KingdomsCommand {
    public CommandAdminMasswar(KingdomsParentCommand parent) {
        super("masswar", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.requireArgs(1)) {
            return;
        }
        String[] args = context.args;
        CommandSender sender = context.getSender();
        String option = args[0].toLowerCase(Locale.ENGLISH);
        if (option.equals("start")) {
            if (Masswar.isRunning()) {
                KingdomsLang.COMMAND_ADMIN_MASSWAR_RUNNING.sendMessage(sender);
                return;
            }
            Masswar.start(Kingdoms.get());
        } else if (option.equals("end")) {
            if (!Masswar.isRunning()) {
                KingdomsLang.COMMAND_ADMIN_MASSWAR_NOT_RUNNING.sendMessage(sender);
                return;
            }
            Masswar.stop(Kingdoms.get());
        } else {
            KingdomsLang.COMMAND_ADMIN_MASSWAR_USAGE.sendMessage(sender);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        return Arrays.asList("start", "end");
    }
}

