/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.CommandAdminPurge;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.managers.ConfigWatcher;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.data.DataManager;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.data.StartupCache;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.functions.Function0;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0007\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminPurge;", "Lorg/kingdoms/commands/KingdomsCommand;", "Lorg/bukkit/event/Listener;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "executeX", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "onCommand", "", "event", "Lorg/bukkit/event/server/ServerCommandEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/AsyncPlayerPreLoginEvent;", "Companion", "core"})
public final class CommandAdminPurge
extends KingdomsCommand
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static long ACCEPT_COOLDOWN;
    private static boolean PURGING;
    private static boolean DONE;
    private static boolean FULLY_LOADED;

    public CommandAdminPurge(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("purge", parent);
    }

    @EventHandler(priority=EventPriority.LOW)
    public final void onPlayerJoin(@NotNull AsyncPlayerPreLoginEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!PURGING) {
            return;
        }
        event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_WHITELIST, ChatColor.DARK_RED + " Server is currently whitelisted by kingdoms");
    }

    @EventHandler
    public final void onCommand(@NotNull ServerCommandEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!PURGING) {
            return;
        }
        if (Intrinsics.areEqual((Object)event.getCommand(), (Object)"stop")) {
            if (DONE) {
                Bukkit.shutdown();
            } else {
                KingdomsLang.COMMAND_ADMIN_PURGE_STOP.sendError(event.getSender(), new Object[0]);
            }
        } else {
            KingdomsLang.COMMAND_ADMIN_PURGE_COMMAND.sendError(event.getSender(), new Object[0]);
            event.setCancelled(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        int $i$f$forEach;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getSender() instanceof Player) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_PURGE_CONSOLE_ONLY, new Object[0]);
            return CommandResult.FAILED;
        }
        if (PURGING) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_PURGE_ALREADY, new Object[0]);
            return CommandResult.FAILED;
        }
        if (!FULLY_LOADED) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_PURGE_NOT_LOADED, new Object[0]);
            return CommandResult.FAILED;
        }
        if (ACCEPT_COOLDOWN == 0L || Duration.ofSeconds(5L).minus(Duration.ofMillis(System.currentTimeMillis() - ACCEPT_COOLDOWN)).isNegative()) {
            ACCEPT_COOLDOWN = System.currentTimeMillis();
            context.sendError(KingdomsLang.COMMAND_ADMIN_PURGE_CONFIRM, new Object[0]);
            return CommandResult.PARTIAL;
        }
        PURGING = true;
        ConfigWatcher.setAccepting(false);
        List errors = new ArrayList();
        Companion.tryThis(errors, (Function0<Unit>)((Function0)executeX.1.INSTANCE));
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_PURGE_PURGING, new Object[0]);
        KingdomsDataCenter data = KingdomsDataCenter.get();
        Iterator<Group> iterator = new KingdomItemRemoveContext();
        KingdomItemRemoveContext $this$executeX_u24lambda_u2d0 = iterator;
        boolean bl = false;
        $this$executeX_u24lambda_u2d0.setDropsItem(false);
        KingdomItemRemoveContext removeCtx = iterator;
        for (Land land : data.getLandManager().peekAllData()) {
            KingdomsObject x;
            Iterable $this$forEach$iv;
            try {
                $this$forEach$iv = land.getStructures().values();
                $i$f$forEach = 0;
                for (Object element$iv : $this$forEach$iv) {
                    x = (Structure)element$iv;
                    boolean bl2 = false;
                    Companion.tryThis(errors, (Function0<Unit>)((Function0)new Function0<Unit>((Structure)x, removeCtx){
                        final /* synthetic */ Structure $x;
                        final /* synthetic */ KingdomItemRemoveContext $removeCtx;
                        {
                            this.$x = $x;
                            this.$removeCtx = $removeCtx;
                            super(0);
                        }

                        public final void invoke() {
                            this.$x.remove(this.$removeCtx);
                        }
                    }));
                }
            }
            catch (ConcurrentModificationException ignored) {
                KLogger.warn("ConcurrentModificationException for structures");
            }
            try {
                $this$forEach$iv = land.getTurrets().values();
                $i$f$forEach = 0;
                for (Object element$iv : $this$forEach$iv) {
                    x = (Turret)element$iv;
                    boolean bl3 = false;
                    Companion.tryThis(errors, (Function0<Unit>)((Function0)new Function0<Unit>((Turret)x, removeCtx){
                        final /* synthetic */ Turret $x;
                        final /* synthetic */ KingdomItemRemoveContext $removeCtx;
                        {
                            this.$x = $x;
                            this.$removeCtx = $removeCtx;
                            super(0);
                        }

                        public final void invoke() {
                            this.$x.remove(this.$removeCtx);
                        }
                    }));
                }
            }
            catch (ConcurrentModificationException ignored) {
                KLogger.warn("ConcurrentModificationException for turrets");
            }
            try {
                $this$forEach$iv = land.getProtectedBlocks().values();
                $i$f$forEach = 0;
                for (Object element$iv : $this$forEach$iv) {
                    x = (ProtectionSign)element$iv;
                    boolean bl4 = false;
                    Block block = ((ProtectionSign)x).getSign().getBlock();
                    if (block == null) continue;
                    block.setType(Material.AIR);
                }
            }
            catch (ConcurrentModificationException ignored) {
                KLogger.warn("ConcurrentModificationException for protectedBlocks");
            }
        }
        for (Kingdom kingdom : data.getKingdomManager().getKingdoms()) {
            kingdom.disband(GroupDisband.Reason.ADMIN);
        }
        for (Nation nation : data.getNationManager().getNations()) {
            nation.disband(GroupDisband.Reason.ADMIN);
        }
        Companion.tryThis(errors, (Function0<Unit>)((Function0)new Function0<Unit>(data){
            final /* synthetic */ KingdomsDataCenter $data;
            {
                this.$data = $data;
                super(0);
            }

            public final void invoke() {
                this.$data.getKingdomPlayerManager().clear();
                this.$data.getLandManager().clear();
                this.$data.getKingdomManager().clear();
                this.$data.getNationManager().clear();
                this.$data.getMTG().clear();
            }
        }));
        if (KingdomsConfig.DATABASE_USE_DATA_FOLDER.getManager().getBoolean()) {
            Companion.tryThis(errors, (Function0<Unit>)((Function0)executeX.6.INSTANCE));
        } else {
            void $this$forEach$iv;
            iterator = new DataManager[]{data.getKingdomPlayerManager(), data.getLandManager(), data.getKingdomManager(), data.getNationManager(), data.getMTG()};
            boolean $i$f$forEach2 = false;
            $i$f$forEach = ((void)$this$forEach$iv).length;
            for (int ignored = 0; ignored < $i$f$forEach; ++ignored) {
                void element$iv;
                void x = element$iv = $this$forEach$iv[ignored];
                boolean bl5 = false;
                Companion.tryThis(errors, (Function0<Unit>)((Function0)new Function0<Unit>((DataManager<? extends Object, ? extends KingdomsObject<? extends Object>>)x){
                    final /* synthetic */ DataManager<? extends Object, ? extends KingdomsObject<? extends Object>> $x;
                    {
                        this.$x = $x;
                        super(0);
                    }

                    public final void invoke() {
                        this.$x.deleteAllData();
                    }
                }));
            }
        }
        if (errors.isEmpty()) {
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_PURGE_DONE, new Object[0]);
        } else {
            void $this$mapTo$iv$iv;
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_PURGE_DONE_WITH_ERRORS, new Object[0]);
            Iterable $this$map$iv = errors;
            boolean $i$f$map = false;
            Iterable $i$f$forEach3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                Throwable throwable = (Throwable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(Companion.sanitizeStackTrace((Throwable)x));
            }
            String error = CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (CharSequence)"---------------------------------------------------------------\n", null, null, (int)0, null, null, (int)62, null);
            KLogger.error(error);
        }
        DONE = true;
        KLogger.info("Purging is done. Stopping the server in 5 seconds...");
        Bukkit.getScheduler().runTaskLater((Plugin)KingdomsCommand.plugin, CommandAdminPurge::executeX$lambda-6, 100L);
        return CommandResult.SUCCESS;
    }

    private static final void executeX$lambda-6() {
        KLogger.info("Shutting down...");
        Bukkit.shutdown();
    }

    private static final void lambda-8$lambda-7() {
        FULLY_LOADED = true;
    }

    private static final void _init_$lambda-8(Kingdoms it) {
        Kingdoms.taskScheduler().asyncLater(Duration.ofSeconds(5L), CommandAdminPurge::lambda-8$lambda-7);
    }

    static {
        StartupCache.whenLoaded(CommandAdminPurge::_init_$lambda-8);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminPurge$Companion;", "", "()V", "ACCEPT_COOLDOWN", "", "DONE", "", "FULLY_LOADED", "PURGING", "sanitizeStackTrace", "", "throwable", "", "tryThis", "", "", "trying", "Lorg/kingdoms/libs/kotlin/Function0;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final void tryThis(@NotNull List<Throwable> $this$tryThis, @NotNull Function0<Unit> trying) {
            Intrinsics.checkNotNullParameter($this$tryThis, (String)"<this>");
            Intrinsics.checkNotNullParameter(trying, (String)"trying");
            try {
                trying.invoke();
            }
            catch (Throwable ex) {
                $this$tryThis.add(ex);
            }
        }

        @NotNull
        public final String sanitizeStackTrace(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            StringBuilder builder = new StringBuilder(1000);
            Throwable error = throwable;
            while (error.getCause() != null) {
                Intrinsics.checkNotNull((Object)error.getCause());
            }
            StackTraceElement[] stackTraceElementArray = error.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"error.stackTrace");
            StackTraceElement[] stackTrace = stackTraceElementArray;
            builder.append(error.getMessage()).append('\n');
            for (StackTraceElement stack : stackTrace) {
                String clazz = stack.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"clazz");
                if (StringsKt.contains$default((CharSequence)clazz, (CharSequence)"org.kingdoms.commands.admin.CommandAdminPurge", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)clazz, (char)'$', (boolean)false, (int)2, null)) continue;
                if (clazz.equals(KingdomsCommandHandler.class.getName())) break;
                builder.append("     ").append(clazz).append("->").append(stack.getMethodName()).append(':').append(stack.getLineNumber()).append('\n');
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

