/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.JoinAndLeaveManager;
import org.kingdoms.utils.internal.integer.IntHashSet;

public final class CommandAdminTrack
extends KingdomsCommand {
    private static final IntHashSet TRACKERS = new IntHashSet();

    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        int id;
        int n = id = context.isPlayer() ? context.senderAsPlayer().getEntityId() : 0;
        if (TRACKERS.contains(id)) {
            TRACKERS.remove(id);
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_TRACK_DISABLED, new Object[0]);
        } else {
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_TRACK_ENABLED, new Object[0]);
            TRACKERS.add(id);
        }
        return CommandResult.SUCCESS;
    }

    public CommandAdminTrack(@NotNull KingdomsParentCommand parent) {
        super("track", parent);
    }

    public static boolean isTracking(@NotNull CommandSender sender) {
        return TRACKERS.contains(sender instanceof Player ? ((Player)sender).getEntityId() : 0);
    }

    static {
        JoinAndLeaveManager.LEAVE_HANDLERS.add(player -> TRACKERS.remove(player.getEntityId()));
    }
}

