/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging.debug;

import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.debugging.debug.CommandAdminDebug;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.DebugSettings;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/kingdoms/commands/admin/debugging/debug/CommandAdminDebugToggle;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "executeX", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "core"})
public final class CommandAdminDebugToggle
extends KingdomsCommand {
    public CommandAdminDebugToggle(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("toggle", parent);
    }

    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DebugSettings settings = DebugSettings.Companion.getSettings(context);
        if (CommandAdminDebug.warnDebugNotEnabled(context)) {
            return CommandResult.FAILED;
        }
        Intrinsics.checkNotNullExpressionValue((Object)context.args, (String)"context.args");
        for (String arg : context.args) {
            DebugNS ns = DebugNS.fromString(arg);
            context.var("debug", arg);
            if (ns == null) {
                context.sendError(KingdomsLang.COMMAND_ADMIN_DEBUG_UNKNOWN_DEBUG, new Object[0]);
                continue;
            }
            if (settings.getList().add(ns)) {
                context.sendMessage(KingdomsLang.COMMAND_ADMIN_DEBUG_TOGGLE_ADDED, new Object[0]);
                continue;
            }
            settings.getList().remove(ns);
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_DEBUG_TOGGLE_REMOVED, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }
}

