/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.item;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.ResourcePointManager;
import org.kingdoms.utils.string.StringUtils;

public class CommandAdminItemInject
extends KingdomsCommand {
    public CommandAdminItemInject(KingdomsParentCommand parent) {
        super("inject", parent);
    }

    @Override
    public void execute(CommandContext context) {
        ItemMeta meta;
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        if (!context.isNumber(0)) {
            context.sendError(KingdomsLang.INVALID_NUMBER, "arg", context.arg(0));
            return;
        }
        double worth = Double.parseDouble(context.arg(0));
        Player player = context.senderAsPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_ITEM_INJECT_NO_ITEM, new Object[0]);
            return;
        }
        item = ResourcePointManager.injectWorth(item, worth);
        player.getInventory().setItemInMainHand(item);
        String name = null;
        if (item.hasItemMeta() && (meta = item.getItemMeta()).hasDisplayName()) {
            name = meta.getDisplayName();
        }
        if (name == null) {
            name = XMaterial.matchXMaterial(item).toString();
        }
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_ITEM_INJECT_DONE, "rp", StringUtils.toFancyNumber(worth), "item", name);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandAdminItemInject.tabComplete("&2<amount>");
        }
        return CommandAdminItemInject.emptyTab();
    }
}

