/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.book;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.book.CommandBook;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.book.BookManager;
import org.kingdoms.managers.book.BookSession;

public class CommandBookEdit
extends KingdomsCommand
implements Listener {
    public CommandBookEdit(KingdomsParentCommand parent) {
        super("edit", parent);
    }

    @Override
    public void execute(CommandContext context) {
        List<String> pages;
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        if (!kp.hasPermission(StandardKingdomPermission.LORE)) {
            context.sendError(KingdomsLang.COMMAND_BOOK_PERMISSION, new Object[0]);
            return;
        }
        BookSession editingChapter = BookManager.getSession(player);
        if (editingChapter != null) {
            if (editingChapter.getData() instanceof Wrapper) {
                String chapter = ((Wrapper)editingChapter.getData()).string;
                context.sendError(KingdomsLang.COMMAND_BOOK_EDIT_ALREADY_EDITING, "chapter", chapter);
            } else {
                context.sendError(KingdomsLang.BOOKS_USED_BY_ANOTHER_SESSION, new Object[0]);
            }
            return;
        }
        int slot = BookManager.findEmptyHotbarSlot(player);
        if (slot < 0) {
            context.sendError(KingdomsLang.BOOKS_NO_EMPTY_SLOT, new Object[0]);
            return;
        }
        String chapterName = context.arg(0);
        BookChapter chapter = kingdom.getBook().get(chapterName);
        if (chapter == null) {
            int limit = KingdomsConfig.BOOK_LIMIT.getInt();
            if (kingdom.getBook().size() >= limit) {
                context.sendError(KingdomsLang.COMMAND_BOOK_EDIT_CREATE_LIMIT, "limit", limit, "chapter", chapterName);
                return;
            }
            int maxLength = KingdomsConfig.BOOK_TITLE_MAX_LENGTH.getInt();
            if (chapterName.length() > maxLength) {
                context.sendError(KingdomsLang.COMMAND_BOOK_EDIT_CREATE_MAX_LENGTH, "max", maxLength, "limit", limit, "chapter", chapterName);
                return;
            }
            context.sendError(KingdomsLang.COMMAND_BOOK_EDIT_CREATE, "chapter", chapterName);
            pages = new ArrayList<String>();
        } else {
            pages = chapter.getPages();
        }
        BookManager.handle(player, new BookSession(slot, event -> CommandBookEdit.onSign(player, slot, event), new Wrapper(chapterName)), pages, chapterName);
    }

    private static void onSign(Player player, int slot, PlayerEditBookEvent event) {
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        int limit = KingdomsConfig.BOOK_LIMIT.getInt();
        String chapterName = event.getNewBookMeta().getTitle();
        if (kingdom.getBook().size() >= limit) {
            KingdomsLang.COMMAND_BOOK_EDIT_CREATE_LIMIT.sendError((CommandSender)player, "limit", limit, "chapter", chapterName);
            return;
        }
        int maxLength = KingdomsConfig.BOOK_TITLE_MAX_LENGTH.getInt();
        if (chapterName.length() > maxLength) {
            KingdomsLang.COMMAND_BOOK_EDIT_CREATE_MAX_LENGTH.sendError((CommandSender)event.getPlayer(), "max", maxLength, "title", chapterName);
            event.setCancelled(true);
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
            ItemStack book = player.getInventory().getItem(slot);
            BookMeta meta = (BookMeta)book.getItemMeta();
            BookChapter chapter = new BookChapter(chapterName, meta.getPages());
            BookManager.removeBook(player);
            kingdom.getBook().put(chapter.getName(), chapter);
            KingdomsLang.COMMAND_BOOK_EDIT_CHANGED.sendMessage((CommandSender)player, "book", chapter.getName(), "pages", meta.getPageCount());
        }, 1L);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        return CommandBook.tabCompleteBooks(context);
    }

    private static final class Wrapper {
        private final String string;

        private Wrapper(String string) {
            this.string = string;
        }
    }
}

