/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.book;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.book.CommandBook;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandBookRemove
extends KingdomsCommand {
    public CommandBookRemove(KingdomsParentCommand parent) {
        super("remove", parent);
    }

    @Override
    public void execute(CommandContext context) {
        BookChapter chapter = CommandBook.initialCheckup(context, KingdomsLang.COMMAND_BOOK_REMOVE_USAGE, true);
        if (chapter == null) {
            return;
        }
        Kingdom kingdom = context.getKingdom();
        kingdom.getBook().remove(chapter.getName());
        context.sendMessage(KingdomsLang.COMMAND_BOOK_REMOVE_DELETED, "chapter", chapter.getName());
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        return CommandBook.tabCompleteBooks(context);
    }
}

