/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.utils.internal.Fn;

public class CommandClaimFill
extends KingdomsCommand {
    public CommandClaimFill(KingdomsParentCommand parent) {
        super("fill", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        SimpleChunkLocation chunk = SimpleChunkLocation.of(player.getLocation());
        Land masterLand = chunk.getLand();
        if (masterLand != null && masterLand.isClaimed()) {
            KingdomsLang.COMMAND_CLAIM_FILL_IN_CLAIMED_LAND.sendMessage((CommandSender)player);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            FloodFill ff = new FloodFill(kingdom, kp, chunk);
            Messenger error = ff.fill();
            ClaimClipboard.addClipboard(player, (Map)Fn.cast(ff.chunks));
            kp.buildMap().clipboardMode().display();
            if (error != null) {
                context.sendError(error, "lands", ff.maxClaims);
            } else {
                context.sendMessage(KingdomsLang.COMMAND_CLAIM_FILL_DONE, new Object[0]);
            }
        });
    }

    private static final class FloodFill {
        private final Kingdom kingdom;
        private final KingdomPlayer kp;
        private final int chunksLimit;
        private final SimpleChunkLocation mainChunk;
        private final Map<SimpleChunkLocation.WorldlessWrapper, ClaimClipboard.ClaimProcessor> chunks;
        private final Queue<SimpleChunkLocation> groups = new LinkedList<SimpleChunkLocation>();
        private final int maxClaims;

        public FloodFill(Kingdom kingdom, KingdomPlayer kp, SimpleChunkLocation mainChunk) {
            this.kingdom = kingdom;
            this.kp = kp;
            this.mainChunk = mainChunk;
            this.chunksLimit = KingdomsConfig.Claims.FILL_MAX_CLAIMS.getManager().getInt();
            this.chunks = new HashMap<SimpleChunkLocation.WorldlessWrapper, ClaimClipboard.ClaimProcessor>(this.chunksLimit);
            this.chunks.put(mainChunk.worldlessWrapper(), new ClaimClipboard.ClaimProcessor(mainChunk, kp, kingdom));
            if (kp.isAdmin()) {
                this.maxClaims = Integer.MAX_VALUE;
            } else {
                int rankMaxClaims = kp.getRank().getMaxClaims();
                int kingdomMaxLands = kingdom.getMaxClaims(mainChunk.getWorld());
                int leftKingdomClaims = Math.max(0, kingdomMaxLands - kingdom.getLandLocations().size());
                this.maxClaims = rankMaxClaims > 0 ? Math.min(Math.max(0, rankMaxClaims - kp.getClaims().size()), leftKingdomClaims) : leftKingdomClaims;
            }
        }

        private Messenger fill() {
            if (this.maxClaims <= 0) {
                return KingdomsLang.COMMAND_CLAIM_FILL_MAX_CLAIMS;
            }
            double maxIterations = this.kp.isAdmin() ? 500.0 : KingdomsConfig.Claims.FILL_MAX_ITERATIONS.getManager().getDouble();
            int iterationCount = -10;
            if (!this.computeChunk(this.mainChunk)) {
                return KingdomsLang.COMMAND_CLAIM_FILL_MAX_CLAIMS;
            }
            while (!this.groups.isEmpty()) {
                if ((double)iterationCount > maxIterations) {
                    return KingdomsLang.COMMAND_CLAIM_FILL_MAX_ITERATIONS;
                }
                SimpleChunkLocation next = this.groups.poll();
                if (next == null) {
                    return null;
                }
                if (!this.computeChunk(next)) {
                    return KingdomsLang.COMMAND_CLAIM_FILL_MAX_CLAIMS;
                }
                ++iterationCount;
            }
            return null;
        }

        private boolean computeChunk(SimpleChunkLocation around) {
            SimpleChunkLocation mono = around.getRelative(1, 0);
            SimpleChunkLocation di = around.getRelative(-1, 0);
            SimpleChunkLocation tri = around.getRelative(0, 1);
            SimpleChunkLocation tetra = around.getRelative(0, -1);
            for (SimpleChunkLocation chunk : new SimpleChunkLocation[]{mono, di, tri, tetra}) {
                Land land;
                if (!this.kp.isAdmin() && this.chunks.size() >= this.maxClaims) {
                    return false;
                }
                if (this.chunks.containsKey(chunk.worldlessWrapper()) || (land = chunk.getLand()) != null && land.isClaimed()) continue;
                ClaimClipboard.ClaimProcessor processor = new ClaimClipboard.ClaimProcessor(chunk, this.kp, this.kingdom);
                if (this.chunks.put(chunk.worldlessWrapper(), processor) != null) continue;
                this.groups.add(chunk);
            }
            return true;
        }
    }
}

