/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.utils.internal.Fn;

public class CommandClaimSquare
extends KingdomsCommand {
    public CommandClaimSquare(KingdomsParentCommand parent) {
        super("square", parent);
    }

    public static Pair<SimpleChunkLocation, SimpleChunkLocation> getCenteredSquareCorners(SimpleChunkLocation chunk, int radius) {
        int plus = radius % 2;
        return Pair.of(chunk.getRelative(-(radius /= 2), -radius), chunk.getRelative(radius + plus, radius + plus));
    }

    public static Map<SimpleChunkLocation.WorldlessWrapper, ClaimClipboard.ClaimProcessor> claimSquare(SimpleChunkLocation from, SimpleChunkLocation to, KingdomPlayer kp, Kingdom kingdom) {
        if (!from.getWorld().equals(to.getWorld())) {
            throw new IllegalArgumentException("Cannot claim a square in two unrelated worlds: " + from.getWorld() + " - " + to.getWorld());
        }
        HashMap<SimpleChunkLocation.WorldlessWrapper, ClaimClipboard.ClaimProcessor> claims = new HashMap<SimpleChunkLocation.WorldlessWrapper, ClaimClipboard.ClaimProcessor>();
        boolean incrementX = from.getX() < to.getX();
        boolean incrementZ = from.getZ() < to.getZ();
        for (int x = from.getX(); x != to.getX(); x += incrementX ? 1 : -1) {
            for (int z = from.getZ(); z != to.getZ(); z += incrementZ ? 1 : -1) {
                SimpleChunkLocation current = new SimpleChunkLocation(from.getWorld(), x, z);
                claims.put(current.worldlessWrapper(), new ClaimClipboard.ClaimProcessor(current, kp, kingdom));
            }
        }
        return claims;
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        int maxRadius = KingdomsConfig.Claims.SQUARE_MAX_RADIUS.getManager().getInt();
        context.var("max", maxRadius).var("radius", context.arg(0));
        if (!context.isNumber(0)) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_SQUARE_RADIUS_INVALID, new Object[0]);
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        int radius = context.intArg(0);
        if (!(kp.isAdmin() || radius >= 2 && radius <= maxRadius)) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_SQUARE_RADIUS_DISALLOWED, new Object[0]);
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        KingdomsLang constantIssue = ClaimProcessor.checkWorldAndPermission(player.getWorld().getName(), kp);
        if (constantIssue != null) {
            context.sendError(constantIssue, new Object[0]);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            SimpleChunkLocation chunk = SimpleChunkLocation.of(player.getLocation());
            Pair<SimpleChunkLocation, SimpleChunkLocation> corners = CommandClaimSquare.getCenteredSquareCorners(chunk, radius);
            Map<SimpleChunkLocation.WorldlessWrapper, ClaimClipboard.ClaimProcessor> result = CommandClaimSquare.claimSquare(corners.getKey(), corners.getValue(), kp, kingdom);
            ClaimClipboard.addClipboard(player, (Map)Fn.cast(result));
            kp.buildMap().clipboardMode().display();
            KingdomsLang.COMMAND_CLAIM_SQUARE_DONE.sendMessage((CommandSender)player);
        });
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return CommandClaimSquare.tabComplete("&2<radius>");
        }
        return CommandClaimSquare.emptyTab();
    }
}

