/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.general.invitations.CommandAccept;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.InviteCode;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIPagination;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.MapsKt;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.Ref;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.SimpleMessenger;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.ItemUtil;
import org.kingdoms.utils.internal.FastUUID;
import org.kingdoms.utils.nbt.ItemNBT;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.time.TimeUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\r"}, d2={"Lorg/kingdoms/commands/general/invitations/CommandInviteCodes;", "Lorg/kingdoms/commands/KingdomsCommand;", "Lorg/bukkit/event/Listener;", "()V", "executeX", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "onInviteAccept", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "Companion", "core"})
public final class CommandInviteCodes
extends KingdomsCommand
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String INVITE_CODE_NBT = "InviteCode";

    public CommandInviteCodes() {
        super("invitecodes", true);
    }

    @EventHandler
    public final void onInviteAccept(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        Player player2 = player;
        ItemStack itemStack = player2.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"player.inventory.itemInMainHand");
        ItemStack item = itemStack;
        org.kingdoms.libs.kotlin.Pair<UUID, String> pair = Companion.getInviteCodeFrom(item);
        if (pair == null) {
            return;
        }
        org.kingdoms.libs.kotlin.Pair<UUID, String> pair2 = pair;
        UUID kingdomId = (UUID)pair2.component1();
        String code = (String)pair2.component2();
        Kingdom kingdom = Kingdom.getKingdom(kingdomId);
        if (kingdom == null) {
            KingdomsLang.INVITE_CODES_KINGDOM_DOESNT_EXIST.sendError((CommandSender)player2, new Object[0]);
            return;
        }
        SimpleMessenger messenger = new SimpleMessenger((CommandSender)player2, new MessageBuilder().withContext(kingdom));
        InviteCode inviteCode = kingdom.getInviteCodes().get(code);
        if (inviteCode == null || inviteCode.hasExpired()) {
            messenger.sendError(KingdomsLang.INVITE_CODES_NO_LONGER_VALID, new Object[0]);
            return;
        }
        if (inviteCode.isAllUsed()) {
            messenger.sendError(KingdomsLang.INVITE_CODES_MAX_USES, new Object[0]);
            return;
        }
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player2);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(player)");
        KingdomPlayer kp = kingdomPlayer;
        if (kp.hasKingdom()) {
            messenger.sendError(KingdomsLang.COMMAND_JOIN_ALREADY_IN_KINGDOM, new Object[0]);
            return;
        }
        KingdomsLang requirement = CommandAccept.checkRequirementsToJoin(player2, kingdom);
        if (requirement != null) {
            messenger.sendError(requirement, new Object[0]);
            return;
        }
        inviteCode.getUsedBy().add(player2.getUniqueId());
        kp.joinKingdom(kingdom);
        List<Player> list2 = kingdom.getOnlineMembers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"kingdom.onlineMembers");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player x = (Player)element$iv;
            boolean bl = false;
            KingdomsLang.INVITE_CODES_USED.sendMessage((CommandSender)x);
        }
        if (item.getAmount() == 1) {
            player2.getInventory().setItemInMainHand(null);
        } else {
            int n = item.getAmount();
            item.setAmount(n + -1);
        }
    }

    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        if (!kp.hasPermission(StandardKingdomPermission.INVITE)) {
            StandardKingdomPermission.INVITE.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        Kingdom kingdom = kp.getKingdom();
        Intrinsics.checkNotNull((Object)kingdom);
        Companion.openGUI(player, kingdom);
        return CommandResult.SUCCESS;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\fJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/kingdoms/commands/general/invitations/CommandInviteCodes$Companion;", "", "()V", "INVITE_CODE_NBT", "", "durationOfInviteCode", "", "ctx", "Lorg/kingdoms/gui/OptionHandler;", "input", "(Lorg/kingdoms/gui/OptionHandler;Ljava/lang/String;)Ljava/lang/Long;", "generateInviteCodePaper", "Lorg/bukkit/inventory/ItemStack;", "kingdom", "Lorg/kingdoms/constants/group/Kingdom;", "inviteCode", "Lorg/kingdoms/constants/group/model/InviteCode;", "getEditsOf", "", "getInviteCodeFrom", "Lorg/kingdoms/libs/kotlin/Pair;", "Ljava/util/UUID;", "item", "openGUI", "Lorg/kingdoms/gui/InteractiveGUI;", "player", "Lorg/bukkit/entity/Player;", "page", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InteractiveGUI openGUI(@NotNull Player player, @NotNull Kingdom kingdom) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)kingdom, (String)"kingdom");
            return this.openGUI(player, kingdom, 0);
        }

        private final InteractiveGUI openGUI(Player player, Kingdom kingdom, int page) {
            InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.INVITE$CODES);
            int maxInviteCodes = KingdomsConfig.INVITATIONS_CODES_MAX.getInt();
            long paperCost = KingdomsConfig.INVITATIONS_CODES_PAPER_COST_RESOURCE_POINTS.getLong();
            gui.getSettings().raw("invitecode-paper-cost", paperCost).raw("invitecode-max", maxInviteCodes);
            KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(player)");
            KingdomPlayer kp = kingdomPlayer;
            boolean hasInvitePerm = kp.hasPermission(StandardKingdomPermission.INVITE);
            Pair<ReusableOptionHandler, Collection<InviteCode>> pair = GUIPagination.paginate(gui, kingdom.getInviteCodes().values(), "invite-codes", page, arg_0 -> Companion.openGUI$lambda-0(player, kingdom, arg_0));
            Intrinsics.checkNotNullExpressionValue(pair, (String)"paginate(\n              \u2026yer, kingdom, openPage) }");
            ReusableOptionHandler option = (ReusableOptionHandler)((Map.Entry)pair).getKey();
            Collection codes = (Collection)((Map.Entry)pair).getValue();
            for (InviteCode inviteCode : codes) {
                MessageBuilder messageBuilder = option.getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)inviteCode, (String)"inviteCode");
                messageBuilder.addAll((Map)this.getEditsOf(inviteCode));
                option.on(ClickType.LEFT, arg_0 -> Companion.openGUI$lambda-1(hasInvitePerm, kp, paperCost, kingdom, inviteCode, player, arg_0));
                ((ReusableOptionHandler)option.on(ClickType.MIDDLE, arg_0 -> Companion.openGUI$lambda-2(hasInvitePerm, arg_0))).setConversation((arg_0, arg_1) -> Companion.openGUI$lambda-3(inviteCode, player, kingdom, page, arg_0, arg_1));
                option.on(ClickType.RIGHT, arg_0 -> Companion.openGUI$lambda-4(hasInvitePerm, kingdom, inviteCode, player, page, arg_0));
                option.pushHead(inviteCode.getCreator());
                if (option.hasNext()) continue;
            }
            Ref.ObjectRef duration = new Ref.ObjectRef();
            gui.option("new-invite-code").onNormalClicks(arg_0 -> Companion.openGUI$lambda-5(hasInvitePerm, kingdom, maxInviteCodes, arg_0)).setConversation((arg_0, arg_1) -> Companion.openGUI$lambda-6(duration, kingdom, player, arg_0, arg_1)).done();
            gui.option("delete-all").onNormalClicks(arg_0 -> Companion.openGUI$lambda-7(kingdom, player, arg_0)).done();
            Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"gui");
            InteractiveGUI.open$default(gui, false, false, 3, null);
            return gui;
        }

        private final Long durationOfInviteCode(OptionHandler ctx, String input) {
            Long dur;
            block6: {
                Long maxDuration;
                long minDuration;
                block5: {
                    long l;
                    block4: {
                        dur = TimeUtils.parseTime(input, TimeUnit.DAYS);
                        if (dur == null) {
                            ctx.getSettings().raw("time", input);
                            ctx.sendError(KingdomsLang.INVALID_TIME, new Object[0]);
                            return null;
                        }
                        Long l2 = KingdomsConfig.INVITATIONS_CODES_EXPIRATION_MIN.getTimeMillis();
                        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"INVITATIONS_CODES_EXPIRATION_MIN.timeMillis");
                        minDuration = RangesKt.coerceAtLeast((long)1000L, (long)((Number)l2).longValue());
                        maxDuration = KingdomsConfig.INVITATIONS_CODES_EXPIRATION_MAX.getTimeMillis();
                        l = 0L;
                        if (dur != l) break block4;
                        Intrinsics.checkNotNullExpressionValue((Object)maxDuration, (String)"maxDuration");
                        if (maxDuration > 0L) break block5;
                    }
                    l = 0L;
                    if (dur != l && dur < minDuration) break block5;
                    Intrinsics.checkNotNullExpressionValue((Object)maxDuration, (String)"maxDuration");
                    if (maxDuration <= 0L || dur <= maxDuration) break block6;
                }
                MessageBuilder messageBuilder = ctx.getSettings().raw("duration-min", TimeFormatter.of(minDuration));
                Intrinsics.checkNotNullExpressionValue((Object)maxDuration, (String)"maxDuration");
                messageBuilder.raw("duration-max", TimeFormatter.of(maxDuration));
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_DURATION_OUT_OF_RANGE, new Object[0]);
                return null;
            }
            return dur;
        }

        private final Map<String, Object> getEditsOf(InviteCode inviteCode) {
            org.kingdoms.libs.kotlin.Pair[] pairArray = new org.kingdoms.libs.kotlin.Pair[]{TuplesKt.to((Object)"invitecode-code", (Object)inviteCode.getCode()), TuplesKt.to((Object)"invitecode-creator", (Object)inviteCode.getCreator().getName()), TuplesKt.to((Object)"invitecode-uses", (Object)(inviteCode.getUses() == 0 ? KingdomsLang.UNLIMITED.parse(new Object[0]) : Integer.valueOf(inviteCode.getUses()))), TuplesKt.to((Object)"invitecode-used", (Object)inviteCode.getUsedBy().size()), TuplesKt.to((Object)"invitecode-createdAt", (Object)TimeUtils.getDateAndTime(inviteCode.getCreatedAt())), TuplesKt.to((Object)"invitecode-expiration", (Object)(inviteCode.getExpiration() == 0L ? KingdomsLang.UNLIMITED.parse(new Object[0]) : TimeUtils.getDateAndTime(inviteCode.getExpiration())))};
            return MapsKt.hashMapOf((org.kingdoms.libs.kotlin.Pair[])pairArray);
        }

        @Nullable
        public final org.kingdoms.libs.kotlin.Pair<UUID, String> getInviteCodeFrom(@NotNull ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            NBTWrappers.NBTTagCompound nbt = ItemNBT.getTag(item);
            NBTWrappers.NBTTagCompound nBTTagCompound = nbt.getCompound("Kingdoms");
            if (nBTTagCompound == null) {
                return null;
            }
            NBTWrappers.NBTTagCompound kingdomsCompound = nBTTagCompound;
            NBTWrappers.NBTTagCompound nBTTagCompound2 = kingdomsCompound.getCompound(CommandInviteCodes.INVITE_CODE_NBT);
            if (nBTTagCompound2 == null) {
                return null;
            }
            NBTWrappers.NBTTagCompound mailCompound = nBTTagCompound2;
            UUID group = FastUUID.fromString(mailCompound.get("Group", NBTType.STRING));
            String code = mailCompound.get("Code", NBTType.STRING);
            return new org.kingdoms.libs.kotlin.Pair((Object)group, (Object)code);
        }

        @NotNull
        public final ItemStack generateInviteCodePaper(@NotNull Kingdom kingdom, @NotNull InviteCode inviteCode) {
            Intrinsics.checkNotNullParameter((Object)kingdom, (String)"kingdom");
            Intrinsics.checkNotNullParameter((Object)inviteCode, (String)"inviteCode");
            ItemStack itemStack = XItemStack.deserialize(KingdomsConfig.INVITATIONS_CODES_PAPER_ITEM.getManager().getSection().toBukkitConfigurationSection());
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"deserialize(KingdomsConf\u2026itConfigurationSection())");
            ItemStack item = itemStack;
            ItemMeta meta = item.getItemMeta();
            ItemUtil.translate(meta, ((MessageBuilder)new MessageBuilder().addAll((Map)this.getEditsOf(inviteCode))).withContext(kingdom));
            item.setItemMeta(meta);
            NBTWrappers.NBTTagCompound nbt = ItemNBT.getTag(item);
            NBTWrappers.NBTTagCompound kingdomsNS = new NBTWrappers.NBTTagCompound();
            NBTWrappers.NBTTagCompound container = new NBTWrappers.NBTTagCompound();
            container.setString("Code", inviteCode.getCode());
            container.setString("Group", FastUUID.toString(kingdom.getDataKey()));
            kingdomsNS.setCompound(CommandInviteCodes.INVITE_CODE_NBT, container);
            nbt.setCompound("Kingdoms", kingdomsNS);
            ItemStack itemStack2 = ItemNBT.setTag(item, nbt);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"setTag(item, nbt)");
            return itemStack2;
        }

        private static final void openGUI$lambda-0(Player $player, Kingdom $kingdom, Integer openPage) {
            Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
            Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
            Intrinsics.checkNotNullExpressionValue((Object)openPage, (String)"openPage");
            Companion.openGUI($player, $kingdom, openPage);
        }

        private static final void openGUI$lambda-1(boolean $hasInvitePerm, KingdomPlayer $kp, long $paperCost, Kingdom $kingdom, InviteCode $inviteCode, Player $player, OptionHandler ctx) {
            Intrinsics.checkNotNullParameter((Object)$kp, (String)"$kp");
            Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
            Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
            if (!$hasInvitePerm) {
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_PERMISSION_GET, new Object[0]);
                return;
            }
            if (!$kp.isAdmin() && $paperCost > 0L) {
                if (!$kingdom.hasResourcePoints($paperCost)) {
                    ctx.sendError(KingdomsLang.COMMAND_INVITECODES_PAPER_COST, new Object[0]);
                    return;
                }
                $kingdom.addResourcePoints(-$paperCost);
            }
            Intrinsics.checkNotNullExpressionValue((Object)$inviteCode, (String)"inviteCode");
            ItemStack paper = Companion.generateInviteCodePaper($kingdom, $inviteCode);
            ItemStack[] itemStackArray = new ItemStack[]{paper};
            XItemStack.giveOrDrop($player, itemStackArray);
            ctx.sendMessage(KingdomsLang.COMMAND_INVITECODES_PAPER_GIVE, new Object[0]);
        }

        private static final void openGUI$lambda-2(boolean $hasInvitePerm, OptionHandler ctx) {
            if (!$hasInvitePerm) {
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_PERMISSION_REDEEM, new Object[0]);
                return;
            }
            ctx.sendMessage(KingdomsLang.COMMAND_INVITECODES_REDEEM_ENTER, new Object[0]);
            ctx.startConversation();
        }

        private static final void openGUI$lambda-3(InviteCode $inviteCode, Player $player, Kingdom $kingdom, int $page, OptionHandler ctx, String input) {
            Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
            Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
            Intrinsics.checkNotNullExpressionValue((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
            Long dur = Companion.durationOfInviteCode(ctx, input);
            if (dur != null) {
                ctx.endConversation();
                $inviteCode.redeemFor(TimeUtils.afterNow(Duration.ofMillis(dur)));
                Companion.openGUI($player, $kingdom, $page);
            }
        }

        private static final void openGUI$lambda-4(boolean $hasInvitePerm, Kingdom $kingdom, InviteCode $inviteCode, Player $player, int $page, OptionHandler ctx) {
            Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
            Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
            if (!$hasInvitePerm) {
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_PERMISSION_DELETE, new Object[0]);
                return;
            }
            $kingdom.getInviteCodes().remove($inviteCode.getCode());
            Companion.openGUI($player, $kingdom, $page);
        }

        private static final void openGUI$lambda-5(boolean $hasInvitePerm, Kingdom $kingdom, int $maxInviteCodes, OptionHandler ctx) {
            Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
            if (!$hasInvitePerm) {
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_PERMISSION_CREATE, new Object[0]);
                return;
            }
            if ($kingdom.getInviteCodes().size() >= $maxInviteCodes) {
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_MAX, new Object[0]);
                return;
            }
            ctx.sendMessage(KingdomsLang.COMMAND_INVITECODES_DURATION_ENTER, new Object[0]);
            ctx.startConversation();
        }

        private static final void openGUI$lambda-6(Ref.ObjectRef $duration, Kingdom $kingdom, Player $player, OptionHandler ctx, String input) {
            Intrinsics.checkNotNullParameter((Object)$duration, (String)"$duration");
            Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
            Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
            int uses = 0;
            if ($duration.element == null) {
                Intrinsics.checkNotNullExpressionValue((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
                Long dur = Companion.durationOfInviteCode(ctx, input);
                if (dur != null) {
                    $duration.element = new AtomicLong(dur);
                    ctx.sendMessage(KingdomsLang.COMMAND_INVITECODES_USES_ENTER, new Object[0]);
                }
                return;
            }
            try {
                uses = Integer.parseInt(input);
            }
            catch (NumberFormatException ex) {
                ctx.getSettings().raw("arg", input);
                ctx.sendError(KingdomsLang.INVALID_NUMBER, new Object[0]);
                return;
            }
            int minUses = RangesKt.coerceAtLeast((int)1, (int)KingdomsConfig.INVITATIONS_CODES_USES_MIN.getInt());
            int maxUses = KingdomsConfig.INVITATIONS_CODES_USES_MAX.getInt();
            if (uses == 0 && maxUses > 0 || uses != 0 && uses < minUses || maxUses > 0 && uses > maxUses) {
                ctx.getSettings().raw("uses-min", minUses).raw("uses-max", maxUses);
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_USES_OUT_OF_RANGE, new Object[0]);
                return;
            }
            Object object = $duration.element;
            Intrinsics.checkNotNull((Object)object);
            InviteCode code = $kingdom.generateInviteCode(Duration.ofMillis(((AtomicLong)object).get()), $player.getUniqueId(), uses);
            Map<String, InviteCode> map = $kingdom.getInviteCodes();
            Intrinsics.checkNotNullExpressionValue(map, (String)"kingdom.inviteCodes");
            Map<String, InviteCode> map2 = map;
            map2.put(code.getCode(), code);
            ctx.endConversation();
            Companion.openGUI($player, $kingdom);
        }

        private static final void openGUI$lambda-7(Kingdom $kingdom, Player $player, OptionHandler ctx) {
            Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
            Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
            $kingdom.getInviteCodes().clear();
            Companion.openGUI($player, $kingdom);
            ctx.sendMessage(KingdomsLang.COMMAND_INVITECODES_DELETED_ALL, new Object[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

