/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.inviterequests.JoinRequests;
import org.kingdoms.utils.KingdomsBukkitExtensions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/commands/general/invitations/CommandRequestJoin;", "Lorg/kingdoms/commands/KingdomsCommand;", "()V", "executeX", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
public final class CommandRequestJoin
extends KingdomsCommand {
    public CommandRequestJoin() {
        super("requestJoin", true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        if (kp.hasKingdom()) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_JOIN_ALREADY_IN_KINGDOM, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(KingdomsLan\u2026_JOIN_ALREADY_IN_KINGDOM)");
            return commandResult;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        Kingdom requestedKingdom = kingdom;
        if (JoinRequests.Companion.getJoinRequests(requestedKingdom).containsKey(kp.getId())) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_REQUESTJOIN_ALREADY_SENT, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(KingdomsLan\u2026REQUESTJOIN_ALREADY_SENT)");
            return commandResult;
        }
        List<Player> list2 = requestedKingdom.getOnlineMembers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"requestedKingdom.onlineMembers");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player x = (Player)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
            if (!KingdomsBukkitExtensions.INSTANCE.asKingdomPlayer((OfflinePlayer)x).hasPermission(StandardKingdomPermission.INVITE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player x = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
            context.sendMessage((CommandSender)x, KingdomsLang.COMMAND_REQUESTJOIN_SENT_ANNOUNCE, new Object[0]);
        }
        context.getSettings().withContext(requestedKingdom);
        context.sendMessage(KingdomsLang.COMMAND_REQUESTJOIN_SENT, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)kp, (String)"kp");
        JoinRequests.Companion.sendJoinRequestTo(kp, requestedKingdom);
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<String> list2 = context.getKingdoms(0);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"context.getKingdoms(0)");
        return list2;
    }
}

