/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.logs.misc.challenge.LogKingdomChallenged;
import org.kingdoms.constants.group.model.logs.misc.challenge.LogKingdomChallenger;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.Fn;
import org.kingdoms.utils.time.TimeUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/commands/general/misc/CommandChallenge;", "Lorg/kingdoms/commands/KingdomsCommand;", "()V", "executeX", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
public final class CommandChallenge
extends KingdomsCommand {
    public CommandChallenge() {
        super("challenge", true);
    }

    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!KingdomsConfig.Invasions.CHALLENGES_ENABLED.getManager().getBoolean()) {
            MessageHandler.sendPluginMessage(context.getSender(), "&4Challenges aren't enabled");
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        Intrinsics.checkNotNull((Object)kingdom);
        Kingdom kingdom2 = kingdom;
        Player player = context.senderAsPlayer();
        if (!kp.hasPermission(StandardKingdomPermission.INVADE)) {
            StandardKingdomPermission.INVADE.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        Kingdom kingdom3 = (Kingdom)context.generalSelector(false);
        if (kingdom3 == null) {
            return CommandResult.FAILED;
        }
        Kingdom challengedKingdom = kingdom3;
        if (Intrinsics.areEqual((Object)challengedKingdom.getDataKey(), (Object)kp.getKingdomId())) {
            context.sendError(KingdomsLang.COMMAND_CHALLENGE_YOURSELF, new Object[0]);
            return CommandResult.FAILED;
        }
        if (challengedKingdom.getChallenges().containsKey(kingdom2.getDataKey())) {
            context.sendError(KingdomsLang.COMMAND_CHALLENGE_ALREADY_CHALLENGED, new Object[0]);
            return CommandResult.FAILED;
        }
        InteractiveGUI interactiveGUI = GUIAccessor.prepare(player, KingdomsGUI.CHALLENGE);
        if (interactiveGUI == null) {
            return CommandResult.FAILED;
        }
        InteractiveGUI gui = interactiveGUI;
        for (String option : gui.getRemainingOptions("time")) {
            gui.push(option, () -> CommandChallenge.executeX$lambda-0(gui, option, challengedKingdom, kp, kingdom2, player), new Object[0]);
        }
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<String> list2 = context.tabCompleteGeneralSelector(false, true, Fn.alwaysTrue());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"context.tabCompleteGener\u2026e, true, Fn.alwaysTrue())");
        return list2;
    }

    private static final void executeX$lambda-0(InteractiveGUI $gui, String $option, Kingdom $challengedKingdom, KingdomPlayer $kp, Kingdom $kingdom, Player $player) {
        Intrinsics.checkNotNullParameter((Object)$gui, (String)"$gui");
        Intrinsics.checkNotNullParameter((Object)$option, (String)"$option");
        Intrinsics.checkNotNullParameter((Object)$challengedKingdom, (String)"$challengedKingdom");
        Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
        String[] stringArray = new String[]{$option};
        ConfigSection settings = $gui.getOptionsSection().getSection(stringArray);
        long l = System.currentTimeMillis();
        Long l2 = TimeUtils.parseTime(settings.getString("time"));
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"parseTime(settings.getString(\"time\"))");
        long startTime = l + ((Number)l2).longValue();
        Map<UUID, Long> map = $challengedKingdom.getChallenges();
        Intrinsics.checkNotNullExpressionValue(map, (String)"challengedKingdom.challenges");
        Map<UUID, Long> map2 = map;
        UUID uUID = $kp.getKingdomId();
        Iterator<Player> iterator = startTime;
        map2.put(uUID, (Long)((Object)iterator));
        Intrinsics.checkNotNullExpressionValue((Object)$kp, (String)"kp");
        $challengedKingdom.log(new LogKingdomChallenged($kingdom, $kp, startTime));
        $kingdom.log(new LogKingdomChallenger($challengedKingdom, $kp, startTime));
        MessageBuilder msgSettings = new MessageBuilder().withContext($player);
        MessageBuilder selfSettings = new MessageBuilder().withContext($player).withContext($challengedKingdom);
        for (Player member : $challengedKingdom.getOnlineMembers()) {
            Intrinsics.checkNotNullExpressionValue((Object)member, (String)"member");
            CommandSender commandSender = (CommandSender)member;
            Intrinsics.checkNotNullExpressionValue((Object)msgSettings, (String)"msgSettings");
            KingdomsLang.COMMAND_CHALLENGE_CHALLENGED.sendMessage(commandSender, msgSettings);
        }
        for (Player member : $kingdom.getOnlineMembers()) {
            Intrinsics.checkNotNullExpressionValue((Object)member, (String)"member");
            CommandSender commandSender = (CommandSender)member;
            Intrinsics.checkNotNullExpressionValue((Object)selfSettings, (String)"selfSettings");
            KingdomsLang.COMMAND_CHALLENGE_NOTIFY_SELF_MEMBERS.sendMessage(commandSender, selfSettings);
        }
        $player.closeInventory();
    }
}

