/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.awt.Color;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.structures.NexusManager;
import org.kingdoms.utils.ColorUtils;
import org.kingdoms.utils.config.ConfigSection;

public class CommandColor
extends KingdomsCommand {
    public CommandColor() {
        super("color", true);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Kingdom kingdom = context.getKingdom();
        if (context.argsLengthEquals(0)) {
            CommandColor.getColorPicker(context.senderAsPlayer(), kingdom, innerGUI -> innerGUI.push("back", () -> context.senderAsPlayer().closeInventory(), new Object[0]));
            return;
        }
        String colorStr = context.joinArgs();
        Color color = ColorUtils.parseColor(colorStr);
        context.var("color", colorStr);
        if (color == null) {
            context.sendError(KingdomsLang.NEXUS_SETTINGS_COLOR_WRONG_HEX, new Object[0]);
            return;
        }
        context.var("r", color.getRed()).var("b", color.getBlue()).var("g", color.getGreen()).var("hex", color.getRGB()).var("color", ColorUtils.toHexString(color));
        if (!CommandColor.isColorInRange(context.isAdmin(), color)) {
            context.sendError(KingdomsLang.NEXUS_SETTINGS_COLOR_RANGE_BLACKLISTED, new Object[0]);
            return;
        }
        context.sendMessage(KingdomsLang.NEXUS_SETTINGS_COLOR_SET, new Object[0]);
        kingdom.setColor(color, context.getKingdomPlayer());
    }

    public static InteractiveGUI getColorPicker(Player player, Group group, Consumer<InteractiveGUI> handlers) {
        return CommandColor.getColorPicker(player, group.getColor(), (name, color) -> {
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> group.setColor((Color)color, KingdomPlayer.getKingdomPlayer((OfflinePlayer)player)));
            KingdomsLang.NEXUS_SETTINGS_COLOR_SET.sendMessage((CommandSender)player, "color", name, "r", color.getRed(), "b", color.getBlue(), "g", color.getGreen(), "hex", color.getRGB());
        }, handlers);
    }

    public static InteractiveGUI getColorPicker(Player player, Color currentColor, BiConsumer<String, Color> onChoose, Consumer<InteractiveGUI> handlers) {
        if (currentColor == null) {
            currentColor = Color.WHITE;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!NexusManager.admin(player) && !kp.hasPermission(StandardKingdomPermission.SETTINGS)) {
            StandardKingdomPermission.SETTINGS.sendDeniedMessage(player);
            return null;
        }
        String translatedColor = ReflectionUtils.supports(16) ? ChatColor.of((Color)currentColor).toString() : ColorUtils.hexColorToLegacy(currentColor).toString();
        InteractiveGUI gui = GUIAccessor.prepare(player, kp.getOfflinePlayer(), "structures/nexus/settings/color-picker", "r", currentColor.getRed(), "b", currentColor.getBlue(), "g", currentColor.getGreen(), "color", translatedColor);
        if (gui == null) {
            return null;
        }
        gui.push("hex-picker", () -> {
            KingdomsLang.NEXUS_SETTINGS_COLOR_ENTER_VALUE.sendMessage((CommandSender)player);
            gui.startConversation("hex-picker");
        }, color -> {
            Color awtColor;
            if (color.startsWith("#")) {
                awtColor = ColorUtils.hex(color);
                if (awtColor == null) {
                    KingdomsLang.NEXUS_SETTINGS_COLOR_WRONG_HEX.sendMessage((CommandSender)player, "color", color);
                    return;
                }
            } else {
                awtColor = ColorUtils.rgb(color);
                if (awtColor == null) {
                    KingdomsLang.NEXUS_SETTINGS_COLOR_WRONG_RGB.sendMessage((CommandSender)player, "color", color);
                    return;
                }
            }
            if (!CommandColor.isColorInRange(kp.isAdmin(), awtColor)) {
                KingdomsLang.NEXUS_SETTINGS_COLOR_RANGE_BLACKLISTED.sendMessage((CommandSender)player, "color", color);
                return;
            }
            onChoose.accept((String)color, awtColor);
            CommandColor.getColorPicker(player, awtColor, onChoose, handlers);
            gui.endConversation();
        }, new Object[0]);
        for (String holder : gui.getRemainingOptions("color")) {
            ConfigSection sell = gui.getOptionsSection().getSection(holder);
            String color2 = sell.getString("color");
            Color parsed = ColorUtils.parseColor(color2);
            if (parsed == null) continue;
            gui.push(holder, () -> {
                onChoose.accept(color2, parsed);
                CommandColor.getColorPicker(player, parsed, onChoose, handlers);
            }, new Object[0]);
        }
        if (handlers != null) {
            handlers.accept(gui);
        }
        gui.open();
        return gui;
    }

    public static boolean isColorInRange(boolean admin, Color color) {
        if (!admin && KingdomsConfig.COLOR_RANGE_ENABLED.getManager().getBoolean()) {
            float[] hsb = ColorUtils.getHSB(color);
            float hue = hsb[0];
            float saturation = hsb[1];
            float brightness = hsb[2];
            if (saturation > 40.0f && brightness > 40.0f) {
                boolean blacklist = KingdomsConfig.COLOR_RANGE_BLACKLIST.getManager().getBoolean();
                YamlConfigAccessor section = KingdomsConfig.COLOR_RANGE_COLORS.getManager().getSection().noDefault();
                for (String colors : section.getKeys()) {
                    List<Integer> list2 = section.getIntegerList(colors);
                    boolean matches = hue >= (float)list2.get(0).intValue() && hue <= (float)list2.get(1).intValue();
                    if (blacklist != matches) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandColor.tabComplete(KingdomsLang.COMMAND_COLOR_TAB_COMPLETE_HEX.parse(context.getSender(), new Object[0]), KingdomsLang.COMMAND_COLOR_TAB_COMPLETE_RGB.parse(context.getSender(), new Object[0]));
        }
        return CommandColor.emptyTab();
    }
}

