/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.CmdHelpPagination;
import org.kingdoms.utils.internal.nonnull.NonNullSet;
import org.kingdoms.utils.string.StringUtils;
import org.kingdoms.utils.time.TimeFormatter;

public class CommandHelp
extends KingdomsCommand {
    public CommandHelp() {
        super("help", true);
    }

    private static int getPageNumbers(int commands) {
        return commands % 5 != 0 ? commands / 5 + 1 : commands / 5;
    }

    private static KingdomsCommand[] filterAccessiblePages(CommandSender sender) {
        Map<String, KingdomsCommand> all = KingdomsCommandHandler.getCommands(SupportedLanguage.EN);
        NonNullSet<KingdomsCommand> orderedCommands = new NonNullSet<KingdomsCommand>(new LinkedHashSet(all.size()));
        orderedCommands.addAll(KingdomsConfig.HELP_ORDER.getManager().getStringList().stream().map(x -> {
            KingdomsCommand res = (KingdomsCommand)all.get(x);
            if (res == null) {
                KLogger.warn("Unknown command for /k help order: " + x);
            }
            return res;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        orderedCommands.addAll(all.values());
        return (KingdomsCommand[])orderedCommands.stream().filter(c -> c.hasPermission(sender)).toArray(KingdomsCommand[]::new);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertArgs(1) && !context.isNumber(0)) {
            CommandHelp.showInfoOf(context, context.arg(0), KingdomsLang.COMMAND_HELP_INFO);
            return;
        }
        new CmdHelpPagination(context, KingdomsConfig.HELP_COMMANDS.getInt(), () -> CommandHelp.filterAccessiblePages(context.getSender())).execute();
    }

    public static void showInfoOf(CommandContext context, String first, Messenger infoMsg) {
        KingdomsLang permScope;
        if (first.startsWith("/") || first.equals("k")) {
            context.sendError(KingdomsLang.COMMAND_HELP_BAD_START, new Object[0]);
            return;
        }
        KingdomsCommandHandler.CommandInformation cmdInfo = KingdomsCommandHandler.getCommand(context.getSettings().getLanguage(), context.args);
        KingdomsCommand cmd = cmdInfo.command;
        context.var("command", context.joinArgs());
        if (cmd == null) {
            context.sendError(KingdomsLang.COMMAND_HELP_NOT_FOUND, new Object[0]);
            return;
        }
        Object usage = cmd.getUsage().parse(context.getSender(), new Object[0]);
        if (usage == null) {
            usage = KingdomsLang.NONE;
        }
        switch (cmd.getPermission().getDefault()) {
            case TRUE: {
                permScope = KingdomsLang.PLUGIN_PERMISSION_SCOPE_EVERYONE;
                break;
            }
            case FALSE: {
                permScope = KingdomsLang.PLUGIN_PERMISSION_SCOPE_NO_ONE;
                break;
            }
            case OP: {
                permScope = KingdomsLang.PLUGIN_PERMISSION_SCOPE_OP;
                break;
            }
            case NOT_OP: {
                permScope = KingdomsLang.PLUGIN_PERMISSION_SCOPE_NOT_OP;
                break;
            }
            default: {
                KLogger.error("Unknown permission type: " + cmd.getPermission().getDefault());
                permScope = KingdomsLang.UNKNOWN;
            }
        }
        context.getSettings().resetPlaceholders();
        context.getSettings().raws("main-name", cmd.getName(), "parent", cmd.getParent() != null ? cmd.getParent().getName() : KingdomsLang.NONE, "command-displayname", cmd.getDisplayName(), "description", cmd.getDescription().parse(context.getSender(), new Object[0]), "usage", usage, "permission", cmd.getPermission().getName(), "permission-scope", permScope, "cooldown", cmd.getCooldown() >= 0L ? KingdomsLang.NONE : TimeFormatter.of(cmd.getCooldown()));
        List<String> aliases = cmd.getAliases().get((Object)context.getSettings().getLanguage());
        if (aliases.isEmpty()) {
            context.getSettings().raw("aliases", KingdomsLang.NONE);
        } else {
            context.getSettings().parse("aliases", StringUtils.join("&8, ", aliases, (Function<String, String>)((Function)x -> "&9" + x)));
        }
        if (cmd.getDisabledWorlds().isEmpty()) {
            context.getSettings().raw("disabled-worlds", KingdomsLang.NONE);
        } else {
            context.getSettings().parse("disabled-worlds", StringUtils.join("&8, ", cmd.getDisabledWorlds(), (Function<String, String>)((Function)x -> "&9" + x)));
        }
        context.sendMessage(infoMsg, new Object[0]);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        int maxPages = CommandHelp.getPageNumbers(context.isPlayer() ? KingdomsCommandHandler.getCommands(context.getSettings().getLanguage()).size() : CommandHelp.filterAccessiblePages((CommandSender)context.senderAsPlayer()).length);
        ArrayList<String> numbers = new ArrayList<String>(maxPages);
        for (int i = 0; i < maxPages; ++i) {
            numbers.add(Integer.toString(i));
        }
        return numbers;
    }
}

