/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KingdomsPluginPermission;

public class CommandPvP
extends KingdomsCommand {
    public CommandPvP() {
        super("pvp", true);
    }

    @Override
    public void execute(CommandContext context) {
        Player player;
        if (context.assertArgs(1)) {
            if (!context.hasPermission(KingdomsPluginPermission.COMMAND_PVP_OTHERS)) {
                context.sendError(KingdomsLang.COMMAND_PVP_OTHERS_PERMISSION, new Object[0]);
                return;
            }
            player = context.getPlayer(0);
            if (player == null) {
                return;
            }
        } else {
            if (context.assertPlayer()) {
                return;
            }
            player = context.senderAsPlayer();
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        boolean state = context.assertArgs(2) ? context.parseBool(1) : !kp.isPvp();
        context.sendMessage(state ? KingdomsLang.COMMAND_PVP_ON : KingdomsLang.COMMAND_PVP_OFF, new Object[0]);
        kp.setPvp(state);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.hasPermission(KingdomsPluginPermission.COMMAND_PVP_OTHERS)) {
            if (context.isAtArg(1)) {
                return context.getPlayers(0);
            }
            if (context.isAtArg(2)) {
                return CommandPvP.tabComplete("on", "off");
            }
        }
        return CommandPvP.emptyTab();
    }
}

